/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveProtobufSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaTest;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class DeriveProtoBufSchemaTest
extends DeriveSchemaTest {
    private final KafkaProtobufSerializer<DynamicMessage> protobufSerializer;
    private final KafkaProtobufDeserializer<Message> protobufDeserializer;

    public DeriveProtoBufSchemaTest() {
        this.derive = new DeriveProtobufSchema();
        Properties serializerConfig = new Properties();
        serializerConfig.put("schema.registry.url", "bogus");
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        this.protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        this.protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
    }

    @Override
    protected void matchAndValidate(String message, JsonNode schemaString, String expectedSchema) throws IOException {
        ProtobufSchema schema = new ProtobufSchema(schemaString.asText());
        schema.validate(false);
        Assert.assertEquals((Object)schema.toString(), (Object)expectedSchema);
        String formattedString = this.mapper.readTree(message).toString();
        Object protobufObject = ProtobufSchemaUtils.toObject((String)formattedString, (ProtobufSchema)schema);
        DynamicMessage dynamicMessage = (DynamicMessage)protobufObject;
        Assert.assertEquals((Object)protobufObject, (Object)this.protobufDeserializer.deserialize("test", this.protobufSerializer.serialize("test", (Message)dynamicMessage)));
    }

    @Test
    public void testDerivePrimitive() throws JsonProcessingException {
        this.generateSchemaAndCheckPrimitive("12", "{\"type\":\"int32\"}");
        this.generateSchemaAndCheckPrimitive("12232323322323", "{\"type\":\"int64\"}");
        this.generateSchemaAndCheckPrimitive("12.5", "{\"type\":\"double\"}");
        this.generateSchemaAndCheckPrimitive("12020210222344343333333333120202102223443", "{\"type\":\"double\"}");
        this.generateSchemaAndCheckPrimitive("true", "{\"type\":\"bool\"}");
        this.generateSchemaAndCheckPrimitive("\"Test\"", "{\"type\":\"string\"}");
        this.generateSchemaAndCheckPrimitive("", "{\"type\":\"google.protobuf.Any\"}");
        this.generateSchemaAndCheckPrimitive("null", "{\"type\":\"google.protobuf.Any\"}");
    }

    @Test
    public void testDerivePrimitiveForComplex() throws JsonProcessingException {
        this.generateSchemaAndCheckPrimitiveAbsent("[12]");
        this.generateSchemaAndCheckPrimitiveAbsent("{\"F1\":12}");
    }

    @Test
    public void testConvertToFormatArray() throws JsonProcessingException {
        DeriveProtobufSchema deriveProtobuf = (DeriveProtobufSchema)this.derive;
        String arraySchema = deriveProtobuf.convertToFormatArray(this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"number\"}}"), "array", 1);
        Assert.assertEquals((Object)arraySchema, (Object)"repeated number array = 1;\n");
    }

    @Test
    public void testConvertToFormatRecord() throws JsonProcessingException {
        DeriveProtobufSchema deriveProtobuf = (DeriveProtobufSchema)this.derive;
        String recordSchema = deriveProtobuf.convertToFormatRecord(this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}"), "Test");
        Assert.assertEquals((Object)recordSchema, (Object)"message Test { \nrepeated string F1 = 1;\n}\n");
    }

    @Test
    public void testConvertToFormat() throws JsonProcessingException {
        DeriveProtobufSchema deriveProtobuf = (DeriveProtobufSchema)this.derive;
        TextNode recordSchema = deriveProtobuf.convertToFormat(this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}"), "Test");
        Assert.assertEquals((Object)recordSchema.asText(), (Object)"syntax = \"proto3\";\n\nmessage Test {\n  repeated string F1 = 1;\n}\n");
    }

    @Test
    public void testDeriveRecordPrimitive() throws Exception {
        String longMessage = "\"Long\": 1202021212121009";
        String boolMessage = "\"Bool\": true";
        String primitiveTypesMessage = "{" + longMessage + "," + boolMessage + "}";
        String expectedSchema = "syntax = \"proto3\";\n\nmessage Schema {\n  bool Bool = 1;\n  int64 Long = 2;\n}\n";
        this.generateSchemaAndCheckExpected(primitiveTypesMessage, expectedSchema);
    }

    @Test
    public void testDeriveMergeArrays() throws Exception {
        String intMessage = "{\"type\":\"array\",\"items\":{\"type\":\"int32\"}}";
        String doubleMessage = "{\"type\":\"array\",\"items\":{\"type\":\"double\"}}";
        ObjectNode mergedArray = this.derive.mergeArrays(Arrays.asList(this.mapper.readTree(intMessage), this.mapper.readTree(doubleMessage)), true, true);
        Assert.assertEquals((Object)mergedArray.toString(), (Object)"{\"type\":\"array\",\"items\":{\"type\":\"double\"}}");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.derive.mergeArrays(Collections.singletonList(this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"number\"}}}")), false, true));
    }

    @Test
    public void testDeriveRecordComplexTypesWithPrimitiveValues() throws IOException {
        String emptyArrayMessage = "\"emptyArray\":[]";
        String recordOfMultipleMessage = "\"MixedRecord\": {\"Double1\": 1.221, \"name\" : \"T\"}";
        String complexTypesWithPrimitiveValues = "{" + recordOfMultipleMessage + "," + emptyArrayMessage + "}";
        String expectedSchema = "syntax = \"proto3\";\n\nimport \"google/protobuf/any.proto\";\n\nmessage Schema {\n  MixedRecordMessage MixedRecord = 1;\n  repeated google.protobuf.Any emptyArray = 2;\n\n  message MixedRecordMessage {\n    double Double1 = 1;\n    string name = 2;\n  }\n}\n";
        this.generateSchemaAndCheckExpected(complexTypesWithPrimitiveValues, expectedSchema);
    }

    @Test
    public void testDeriveRecordFailure() {
        String arrayOfMultipleTypes = "{\"Record\": [1, true]}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.generateSchemaAndCheckExpected(arrayOfMultipleTypes, ""));
        String recordOfRecords = "{\"RecordOfRecords\": [{\"R1\": {\"N\": 1}}, {\"R1\": {\"N\": \"B\"}}]}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.generateSchemaAndCheckExpected(recordOfRecords, ""));
        String arrayOfNulls = "{\"RecordOfRecords\": [null]}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.generateSchemaAndCheckExpected(arrayOfNulls, ""));
    }

    @Test
    public void testCheckName() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.derive.checkName(""));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.derive.checkName("1"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.derive.checkName("^"));
    }

    @Test
    public void testRecursiveMergingOfNumberTypes() throws IOException {
        String recordOfRecords = "{\"RecordOfNum\": [{\"R1\": {\"N\": 1.5}}, {\"R1\": {\"N\": 1}}]}";
        this.generateSchemaAndCheckExpected(recordOfRecords, "syntax = \"proto3\";\n\nmessage Schema {\n  repeated RecordOfNumMessage RecordOfNum = 1;\n\n  message RecordOfNumMessage {\n    R1Message R1 = 1;\n  \n    message R1Message {\n      double N = 1;\n    }\n  }\n}\n");
    }

    @Test
    public void testRecursiveMergingOfNumberTypesInsideArray() throws IOException {
        JsonNode messageWithArrayOfRecordInt = this.mapper.readTree("{\"F1\": [{\"FF1\":1}]}");
        JsonNode messageWithArrayOfRecordLong = this.mapper.readTree("{\"F1\": [{\"FF1\":112211221122121}]}");
        JsonNode schema = this.derive.getSchemaForMultipleMessages(Arrays.asList(messageWithArrayOfRecordInt, messageWithArrayOfRecordLong)).get("schemas");
        String expectedSchema1 = "syntax = \"proto3\";\n\nmessage Schema {\n  repeated F1Message F1 = 1;\n\n  message F1Message {\n    int64 FF1 = 1;\n  }\n}\n";
        Assert.assertEquals((Object)schema.get(0).get("schema").asText(), (Object)expectedSchema1);
        Assert.assertEquals((Object)schema.get(0).get("messagesMatched").toString(), (Object)"[0,1]");
    }

    @Test
    public void testDeriveMultipleMessages() throws JsonProcessingException {
        JsonNode message1 = this.mapper.readTree("{\"F1\": 1.5, \"F2\": true}");
        JsonNode message2 = this.mapper.readTree("{\"F1\": 1, \"F2\": 1}");
        JsonNode message3 = this.mapper.readTree("{\"F3\": [1, 1.5, 3]}");
        JsonNode message4 = this.mapper.readTree("{\"F1\": 1.5 , \"F2\": true}");
        JsonNode schema = this.derive.getSchemaForMultipleMessages(Arrays.asList(message4, message2, message1, message3, message2)).get("schemas");
        Assert.assertEquals((long)schema.size(), (long)2L);
        String expectedSchema1 = "syntax = \"proto3\";\n\nmessage Schema {\n  double F1 = 1;\n  bool F2 = 2;\n  repeated double F3 = 3;\n}\n";
        Assert.assertEquals((Object)schema.get(0).get("schema").asText(), (Object)expectedSchema1);
        Assert.assertEquals((Object)schema.get(0).get("messagesMatched").toString(), (Object)"[0,2,3]");
        String expectedSchema2 = "syntax = \"proto3\";\n\nmessage Schema {\n  double F1 = 1;\n  int32 F2 = 2;\n  repeated double F3 = 3;\n}\n";
        Assert.assertEquals((Object)schema.get(1).get("schema").asText(), (Object)expectedSchema2);
        Assert.assertEquals((Object)schema.get(1).get("messagesMatched").toString(), (Object)"[1,3,4]");
    }
}

