/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveAvroSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaTest;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class DeriveAvroSchemaTest
extends DeriveSchemaTest {
    private final KafkaAvroSerializer avroSerializer;
    private final KafkaAvroDeserializer avroDeserializer;

    public DeriveAvroSchemaTest() {
        this.derive = new DeriveAvroSchema();
        Properties defaultConfig = new Properties();
        defaultConfig.put("schema.registry.url", "bogus");
        MockSchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
        this.avroSerializer = new KafkaAvroSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(defaultConfig));
        this.avroDeserializer = new KafkaAvroDeserializer((SchemaRegistryClient)schemaRegistry);
    }

    @Override
    protected void matchAndValidate(String message, JsonNode schemaString, String expectedSchema) throws IOException {
        AvroSchema schema = new AvroSchema(schemaString.toString());
        schema.validate(false);
        Assert.assertEquals((Object)schema.toString(), (Object)expectedSchema);
        Object test = AvroSchemaUtils.toObject((String)message, (AvroSchema)schema);
        byte[] bytes = this.avroSerializer.serialize("test", test);
        Assert.assertEquals((Object)test, (Object)this.avroDeserializer.deserialize("test", bytes, schema.rawSchema()));
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        String utf8 = StandardCharsets.UTF_8.name();
        try (PrintStream ps = new PrintStream((OutputStream)bs, true, utf8);){
            AvroSchemaUtils.toJson((Object)test, (OutputStream)ps);
        }
        Assert.assertEquals((Object)this.mapper.readTree(message), (Object)this.mapper.readTree(bs.toString(utf8)));
    }

    private void testUnion(List<String> messages, String expectedSchema) throws IOException {
        ArrayList<ObjectNode> messageObject = new ArrayList<ObjectNode>();
        for (String message : messages) {
            messageObject.add(this.derive.getSchemaForRecord((ObjectNode)this.mapper.readTree(message)));
        }
        ObjectNode merged = this.derive.mergeRecords(messageObject);
        JsonNode schema = this.derive.convertToFormat((JsonNode)merged, "Record");
        for (String message : messages) {
            this.matchAndValidate(message, schema, expectedSchema);
        }
    }

    @Test
    public void testDerivePrimitive() throws JsonProcessingException {
        this.generateSchemaAndCheckPrimitive("12", "{\"type\":\"int\"}");
        this.generateSchemaAndCheckPrimitive("12232323322323", "{\"type\":\"long\"}");
        this.generateSchemaAndCheckPrimitive("12.5", "{\"type\":\"double\"}");
        this.generateSchemaAndCheckPrimitive("12020210222344343333333333120202102223443", "{\"type\":\"double\"}");
        this.generateSchemaAndCheckPrimitive("true", "{\"type\":\"boolean\"}");
        this.generateSchemaAndCheckPrimitive("\"Test\"", "{\"type\":\"string\"}");
        this.generateSchemaAndCheckPrimitive("", "{\"type\":\"null\"}");
        this.generateSchemaAndCheckPrimitive("null", "{\"type\":\"null\"}");
    }

    @Test
    public void testDerivePrimitiveForComplex() throws JsonProcessingException {
        this.generateSchemaAndCheckPrimitiveAbsent("[12]");
        this.generateSchemaAndCheckPrimitiveAbsent("{\"F1\":12}");
    }

    @Test
    public void testConvertToFormatArray() throws JsonProcessingException {
        DeriveAvroSchema deriveAvro = (DeriveAvroSchema)this.derive;
        ObjectNode arraySchema = deriveAvro.convertToFormatArray(this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"number\"}}"), "array");
        Assert.assertEquals((Object)arraySchema.toString(), (Object)"{\"type\":\"array\",\"items\":\"number\"}");
    }

    @Test
    public void testConvertToFormatRecord() throws JsonProcessingException {
        DeriveAvroSchema deriveAvro = (DeriveAvroSchema)this.derive;
        ObjectNode recordSchema = deriveAvro.convertToFormatForRecord(this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}"), "Test");
        Assert.assertEquals((Object)recordSchema.toString(), (Object)"{\"type\":\"record\",\"name\":\"Test\",\"fields\":[{\"name\":\"F1\",\"type\":{\"type\":\"array\",\"items\":\"string\"}}]}");
    }

    @Test
    public void testConvertToFormat() throws JsonProcessingException {
        JsonNode recordSchema = this.derive.convertToFormat(this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}"), "Test");
        Assert.assertEquals((Object)recordSchema.toString(), (Object)"{\"type\":\"record\",\"name\":\"Test\",\"fields\":[{\"name\":\"F1\",\"type\":{\"type\":\"array\",\"items\":\"string\"}}]}");
    }

    @Test
    public void testDeriveRecordPrimitive() throws Exception {
        String longMessage = "\"Long\": 1202021212121009";
        String boolMessage = "\"Bool\": true";
        String primitiveTypesMessage = "{" + longMessage + "," + boolMessage + "}";
        String expectedSchema = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"Bool\",\"type\":\"boolean\"},{\"name\":\"Long\",\"type\":\"long\"}]}";
        this.generateSchemaAndCheckExpected(primitiveTypesMessage, expectedSchema);
    }

    @Test
    public void testDeriveRecordComplexTypesWithPrimitiveValues() throws IOException {
        String emptyArrayMessage = "\"emptyArray\":[]";
        String recordOfMultipleMessage = "\"MixedRecord\": {\"Double1\": 1.221, \"name\" : \"T\"}";
        String complexTypesWithPrimitiveValues = "{" + recordOfMultipleMessage + "," + emptyArrayMessage + "}";
        String expectedSchema = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"MixedRecord\",\"type\":{\"type\":\"record\",\"name\":\"MixedRecord\",\"fields\":[{\"name\":\"Double1\",\"type\":\"double\"},{\"name\":\"name\",\"type\":\"string\"}]}},{\"name\":\"emptyArray\",\"type\":{\"type\":\"array\",\"items\":\"null\"}}]}";
        this.generateSchemaAndCheckExpected(complexTypesWithPrimitiveValues, expectedSchema);
    }

    @Test
    public void testDeriveMergeArrays() throws Exception {
        String intMessage = "{\"type\":\"array\",\"items\":{\"type\":\"int\"}}";
        String doubleMessage = "{\"type\":\"array\",\"items\":{\"type\":\"double\"}}";
        ObjectNode mergedArray = this.derive.mergeArrays(Arrays.asList(this.mapper.readTree(intMessage), this.mapper.readTree(doubleMessage)), true, false);
        Assert.assertEquals((Object)mergedArray.toString(), (Object)"{\"type\":\"array\",\"items\":{\"type\":\"double\"}}");
    }

    @Test
    public void testDeriveMergeArraysForRecord() throws Exception {
        JsonNode recordWithInteger = this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"int\"}}}");
        JsonNode recordWithDouble = this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"double\"}}}");
        ObjectNode mergedArray = this.derive.mergeArrays(Arrays.asList(recordWithDouble, recordWithInteger), false, false);
        Assert.assertEquals((Object)mergedArray.toString(), (Object)"{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"double\"}}}}");
    }

    @Test
    public void testDeriveMergeArraysForRecordInsideArray() throws Exception {
        JsonNode recordWithInteger = this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"int\"}}}}");
        JsonNode recordWithDouble = this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"long\"}}}}");
        ObjectNode mergedArray = this.derive.mergeArrays(Arrays.asList(recordWithDouble, recordWithInteger), false, false);
        Assert.assertEquals((Object)mergedArray.toString(), (Object)"{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"long\"}}}}}");
    }

    @Test
    public void testDeriveMergeArraysFailure() throws Exception {
        JsonNode recordWithInteger = this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"int\"}, \"F2\":{\"type\":\"int\"}}}");
        JsonNode recordWithDouble = this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"double\"}}}");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.derive.mergeArrays(Arrays.asList(recordWithDouble, recordWithInteger), false, false));
        JsonNode arrayOfIntegers = this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"double\"}}");
        JsonNode arrayOfStrings = this.mapper.readTree("{\"type\":\"array\",\"items\":{\"type\":\"string\"}}");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.derive.mergeArrays(Arrays.asList(arrayOfIntegers, arrayOfStrings), false, false));
    }

    @Test
    public void testDeriveMergeUnionsPrimitive() throws IOException {
        String nullMessage = "{\"UnionPrimitive\": null}";
        String intUnionMessage = "{\"UnionPrimitive\": {\"int\":12}}";
        String arrayUnionMessage = "{\"UnionPrimitive\": {\"array\": [true,false]}}";
        this.testUnion(Arrays.asList(nullMessage, intUnionMessage, arrayUnionMessage), "{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"UnionPrimitive\",\"type\":[{\"type\":\"array\",\"items\":\"boolean\"},\"int\",\"null\"]}]}");
    }

    @Test
    public void testDeriveMergeUnionsPrimitiveSingleBranch() throws IOException {
        String stringMessage = "{\"UnionPrimitive\": {\"string\": \"12\"}}";
        this.testUnion(Collections.singletonList(stringMessage), "{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"UnionPrimitive\",\"type\":[\"string\"]}]}");
    }

    @Test
    public void testDeriveArrayOfUnions() throws IOException {
        String arrayOfUnions = "{\"arrayOfUnions\":[{\"int\":12}, {\"double\":1.2}, null, {\"array\":[12,13]}]}";
        String expectedSchema = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"arrayOfUnions\",\"type\":{\"type\":\"array\",\"items\":[{\"type\":\"array\",\"items\":\"int\"},\"double\",\"int\",\"null\"]}}]}";
        this.generateSchemaAndCheckExpected(arrayOfUnions, expectedSchema);
    }

    @Test
    public void testDeriveArrayOfUnionsRecursive() throws IOException {
        String arrayOfUnions = "{\"arr\":[{\"F1\":[null, {\"boolean\":true}]}, {\"F1\":[{\"int\":12}]}, {\"F1\":[null, null]}]}";
        String expectedSchema = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"arr\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"arr\",\"fields\":[{\"name\":\"F1\",\"type\":{\"type\":\"array\",\"items\":[\"boolean\",\"int\",\"null\"]}}]}}}]}";
        this.generateSchemaAndCheckExpected(arrayOfUnions, expectedSchema);
    }

    @Test
    public void testDeriveMergeUnionsRecursive() throws IOException {
        String message1 = "{\"value\": {\"length\": {\"R1\": {\"new\": {\"int\": 5}, \"old\": {\"long\": 523233232333}}}}}";
        String message2 = "{\"value\": {\"length\": {\"R1\": {\"new\": {\"long\": 12121276767225}, \"old\": null}}}}";
        String message3 = "{\"value\": {\"length\": {\"R2\": {\"first\": \"J\", \"second\": \"S\"}}}}";
        this.testUnion(Arrays.asList(message1, message2, message3), "{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"record\",\"name\":\"value\",\"fields\":[{\"name\":\"length\",\"type\":[{\"type\":\"record\",\"name\":\"R2\",\"fields\":[{\"name\":\"first\",\"type\":\"string\"},{\"name\":\"second\",\"type\":\"string\"}]},{\"type\":\"record\",\"name\":\"R1\",\"fields\":[{\"name\":\"new\",\"type\":[\"int\",\"long\"]},{\"name\":\"old\",\"type\":[\"long\",\"null\"]}]}]}]}}]}");
    }

    @Test
    public void testDeriveMergeUnions() throws IOException {
        DeriveAvroSchema deriveAvro = (DeriveAvroSchema)this.derive;
        JsonNode recordWithString = this.mapper.readTree(String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "string"));
        JsonNode recordWithInteger = this.mapper.readTree("{\"type\":\"object\",\"properties\":{\"int\":{\"type\":\"int\"}}}");
        deriveAvro.mergeUnions(Arrays.asList(recordWithString, recordWithInteger), new ArrayList());
        String expectedSchema = "{\"type\":\"union\",\"properties\":[{\"type\":\"int\"},{\"type\":\"string\"}]}";
        Assert.assertEquals((Object)recordWithString.toString(), (Object)expectedSchema);
        Assert.assertEquals((Object)recordWithInteger.toString(), (Object)expectedSchema);
    }

    @Test
    public void testDeriveUnionsFailure() {
        String nullMessage = "{\"UnionPrimitive\": null}";
        String intMessage = "{\"UnionPrimitive\": 12}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.testUnion(Arrays.asList(nullMessage, intMessage), ""));
        String intF1Message = "{\"UnionPrimitive\": {\"F1\":12}}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.testUnion(Arrays.asList(nullMessage, intF1Message), ""));
        String recordMessage = "{\"UnionPrimitive\": {\"F1\":45, \"F2\":12}}";
        Assert.assertThrows(IllegalArgumentException.class, () -> this.testUnion(Arrays.asList(nullMessage, recordMessage), ""));
    }

    @Test
    public void testDeriveMultipleMessages() throws JsonProcessingException {
        JsonNode message1 = this.mapper.readTree("{\"F1\": 1.5, \"F2\": true}");
        JsonNode message2 = this.mapper.readTree("{\"F1\": 1, \"F2\": 1}");
        JsonNode message3 = this.mapper.readTree("{\"F3\": [1, 1.5, 3]}");
        JsonNode schema = this.derive.getSchemaForMultipleMessages(Arrays.asList(message1, message1, message2, message2, message3, message1, message1)).get("schemas");
        Assert.assertEquals((long)schema.size(), (long)3L);
        String expectedSchema1 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":\"double\"},{\"name\":\"F2\",\"type\":\"boolean\"}]}";
        Assert.assertEquals((Object)schema.get(0).get("schema").toString(), (Object)expectedSchema1);
        Assert.assertEquals((Object)schema.get(0).get("messagesMatched").toString(), (Object)"[0,1,5,6]");
        String expectedSchema2 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":\"double\"},{\"name\":\"F2\",\"type\":\"int\"}]}";
        Assert.assertEquals((Object)schema.get(1).get("schema").toString(), (Object)expectedSchema2);
        Assert.assertEquals((Object)schema.get(1).get("messagesMatched").toString(), (Object)"[2,3]");
        String expectedSchema3 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F3\",\"type\":{\"type\":\"array\",\"items\":\"double\"}}]}";
        Assert.assertEquals((Object)schema.get(2).get("schema").toString(), (Object)expectedSchema3);
        Assert.assertEquals((Object)schema.get(2).get("messagesMatched").toString(), (Object)"[4]");
    }

    @Test
    public void testDeriveMultipleMessagesWithUnion() throws JsonProcessingException {
        JsonNode message1 = this.mapper.readTree("{\"F1\": {\"int\":12}, \"F2\": null}");
        JsonNode message2 = this.mapper.readTree("{\"F1\": {\"long\":12}, \"F2\": {\"array\":[12]}}");
        JsonNode message3 = this.mapper.readTree("{\"F3\": {\"string\":\"1\"}, \"F1\": null}");
        JsonNode schema = this.derive.getSchemaForMultipleMessages(Arrays.asList(message1, message2, message3, message3)).get("schemas");
        Assert.assertEquals((long)schema.size(), (long)2L);
        String expectedSchema1 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":[\"int\",\"long\",\"null\"]},{\"name\":\"F2\",\"type\":[{\"type\":\"array\",\"items\":\"int\"},\"null\"]}]}";
        Assert.assertEquals((Object)schema.get(0).get("schema").toString(), (Object)expectedSchema1);
        Assert.assertEquals((Object)schema.get(0).get("messagesMatched").toString(), (Object)"[0,1]");
        String expectedSchema2 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":[\"int\",\"long\",\"null\"]},{\"name\":\"F3\",\"type\":[\"string\"]}]}";
        Assert.assertEquals((Object)schema.get(1).get("schema").toString(), (Object)expectedSchema2);
        Assert.assertEquals((Object)schema.get(1).get("messagesMatched").toString(), (Object)"[2,3]");
    }

    @Test
    public void testDeriveMultipleMessagesWithUnionAndOtherTypes() throws JsonProcessingException {
        JsonNode message1 = this.mapper.readTree("{\"F1\": {\"int\":12}}");
        JsonNode message2 = this.mapper.readTree("{\"F1\": {\"long\":12}}");
        JsonNode message3 = this.mapper.readTree("{\"F1\": 12}");
        JsonNode message4 = this.mapper.readTree("{\"F1\": [12, 23]}");
        JsonNode schema = this.derive.getSchemaForMultipleMessages(Arrays.asList(message1, message2, message3, message4)).get("schemas");
        Assert.assertEquals((long)schema.size(), (long)3L);
        String expectedSchema1 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":[\"int\",\"long\"]}]}";
        Assert.assertEquals((Object)schema.get(0).get("schema").toString(), (Object)expectedSchema1);
        Assert.assertEquals((Object)schema.get(0).get("messagesMatched").toString(), (Object)"[0,1]");
        String expectedSchema2 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":\"int\"}]}";
        Assert.assertEquals((Object)schema.get(1).get("schema").toString(), (Object)expectedSchema2);
        Assert.assertEquals((Object)schema.get(1).get("messagesMatched").toString(), (Object)"[2]");
        String expectedSchema3 = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":{\"type\":\"array\",\"items\":\"int\"}}]}";
        Assert.assertEquals((Object)schema.get(2).get("schema").toString(), (Object)expectedSchema3);
        Assert.assertEquals((Object)schema.get(2).get("messagesMatched").toString(), (Object)"[3]");
    }
}

