/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class SchemaRegistryMojo
extends AbstractMojo {
    @Parameter(required=true)
    List<String> schemaRegistryUrls;
    private SchemaRegistryClient client;

    void client(SchemaRegistryClient client) {
        this.client = client;
    }

    protected SchemaRegistryClient client() {
        if (null == this.client) {
            this.client = new CachedSchemaRegistryClient(this.schemaRegistryUrls, 1000, null);
        }
        return this.client;
    }

    protected Map<String, Schema> loadSchemas(Map<String, File> subjects) {
        int errorCount = 0;
        LinkedHashMap<String, Schema> results = new LinkedHashMap<String, Schema>();
        for (Map.Entry<String, File> kvp : subjects.entrySet()) {
            Schema.Parser parser = new Schema.Parser();
            this.getLog().debug((CharSequence)String.format("Loading schema for subject(%s) from %s.", kvp.getKey(), kvp.getValue()));
            try {
                FileInputStream inputStream = new FileInputStream(kvp.getValue());
                Throwable throwable = null;
                try {
                    Schema schema = parser.parse((InputStream)inputStream);
                    results.put(kvp.getKey(), schema);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("Exception thrown while loading " + kvp.getValue()), (Throwable)ex);
                ++errorCount;
            }
            catch (SchemaParseException ex) {
                this.getLog().error((CharSequence)("Exception thrown while parsing " + kvp.getValue()), (Throwable)ex);
                ++errorCount;
            }
        }
        if (errorCount > 0) {
            throw new IllegalStateException("One or more schemas could not be loaded.");
        }
        return results;
    }
}

