/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import com.google.inject.internal.util.Preconditions;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="register")
public class RegisterSchemaRegistryMojo
extends SchemaRegistryMojo {
    @Parameter(required=true)
    Map<String, File> subjects = new HashMap<String, File>();
    Map<String, Integer> schemaVersions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, Schema> subjectToSchemaLookup = this.loadSchemas(this.subjects);
        this.schemaVersions = new LinkedHashMap<String, Integer>();
        int errors = 0;
        for (Map.Entry<String, Schema> kvp : subjectToSchemaLookup.entrySet()) {
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("Calling register('%s', '%s')", kvp.getKey(), kvp.getValue().toString(true)));
                }
                Integer id = this.client().register(kvp.getKey(), kvp.getValue());
                Integer version = this.client().getVersion(kvp.getKey(), kvp.getValue());
                this.getLog().info((CharSequence)String.format("Registered subject(%s) with id %s version %s", kvp.getKey(), id, version));
                this.schemaVersions.put(kvp.getKey(), version);
            }
            catch (RestClientException | IOException e) {
                ++errors;
                this.getLog().error((CharSequence)String.format("Exception thrown while registering subject(%s)", kvp.getKey()), e);
            }
        }
        Preconditions.checkState((errors == 0 ? 1 : 0) != 0, (Object)"One or more exceptions were encountered while registering the schemas.");
    }
}

