/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.CustomBearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.StaticTokenCredentialProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class CustomBearerAuthCredentialProviderTest {
    private final String LSRC_ID = "lsrc-dummy";
    private final String POOL_ID = "my-pool-id";

    @Test
    public void testWithStaticTokenProvider() throws MalformedURLException {
        HashMap<String, String> CONFIG_MAP = new HashMap<String, String>();
        CONFIG_MAP.put("bearer.auth.logical.cluster", "lsrc-dummy");
        CONFIG_MAP.put("bearer.auth.identity.pool.id", "my-pool-id");
        CONFIG_MAP.put("bearer.auth.custom.provider.class", StaticTokenCredentialProvider.class.getName());
        CONFIG_MAP.put("bearer.auth.token", "custom-token");
        CustomBearerAuthCredentialProvider provider = new CustomBearerAuthCredentialProvider();
        provider.configure(CONFIG_MAP);
        Assert.assertEquals((Object)"custom-token", (Object)provider.getBearerToken(new URL("http://dummy")));
        Assert.assertEquals((Object)"lsrc-dummy", (Object)provider.getTargetSchemaRegistry());
        Assert.assertEquals((Object)"my-pool-id", (Object)provider.getTargetIdentityPoolId());
    }

    @Test
    public void testWithMyFileTokenProvider() throws IOException {
        String token = "my_custom_file_token";
        Path tempFile = Files.createTempFile("MyTokenFile", "txt", new FileAttribute[0]);
        Files.write(tempFile, token.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        HashMap<String, String> CONFIG_MAP = new HashMap<String, String>();
        CONFIG_MAP.put("bearer.auth.logical.cluster", "lsrc-dummy");
        CONFIG_MAP.put("bearer.auth.identity.pool.id", "my-pool-id");
        CONFIG_MAP.put("bearer.auth.issuer.endpoint.url", tempFile.toString());
        CONFIG_MAP.put("bearer.auth.custom.provider.class", "io.confluent.kafka.schemaregistry.client.security.bearerauth.Resources.MyFileTokenProvider");
        CustomBearerAuthCredentialProvider provider = new CustomBearerAuthCredentialProvider();
        provider.configure(CONFIG_MAP);
        Assert.assertEquals((Object)token, (Object)provider.getBearerToken(new URL("http://dummy")));
        Assert.assertEquals((Object)"lsrc-dummy", (Object)provider.getTargetSchemaRegistry());
        Assert.assertEquals((Object)"my-pool-id", (Object)provider.getTargetIdentityPoolId());
    }
}

