/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import io.confluent.kafka.schemaregistry.utils.WildcardMatcher;
import org.junit.Assert;
import org.junit.Test;

public class WildcardMatcherTest {
    @Test
    public void testMatch() {
        Assert.assertFalse((boolean)WildcardMatcher.match(null, (String)"Foo"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"Foo", null));
        Assert.assertTrue((boolean)WildcardMatcher.match(null, null));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo", (String)"Foo"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"", (String)""));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"", (String)"*"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"", (String)"?"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo", (String)"Fo*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo", (String)"Fo?"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo Bar and Catflap", (String)"Fo*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"Foo", (String)"Bar"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo Bar Foo", (String)"F*o Bar*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo", (String)"*Foo"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"BarFoo", (String)"*Foo"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"Foo", (String)"Foo*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"FooBar", (String)"Foo*"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"FOO", (String)"*Foo"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"BARFOO", (String)"*Foo"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"FOO", (String)"Foo*"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"FOOBAR", (String)"Foo*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"eve", (String)"eve*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"alice.bob.eve", (String)"a*.bob.eve"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"alice.bob.eve", (String)"a*.bob.e*"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"alice.bob.eve", (String)"a*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"alice.bob.eve", (String)"a**"));
        Assert.assertFalse((boolean)WildcardMatcher.match((String)"alice.bob.eve", (String)"alice.bob*"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"alice.bob.eve", (String)"alice.bob**"));
    }
}

