/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.config.provider;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.config.provider.SchemaRegistryConfigProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaRegistryConfigProviderTest {
    private SchemaRegistryConfigProvider provider;

    @Before
    public void setup() throws Exception {
        this.provider = new SchemaRegistryConfigProvider();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("schema.registry.url", "mock://config");
        this.provider.configure(configs);
        SchemaRegistryClient schemaRegistryClient = MockSchemaRegistry.getClientForScope((String)"config");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        properties.put("key3", "value3");
        Metadata m = new Metadata(Collections.emptyMap(), properties, null);
        AvroSchema schema = SchemaRegistryConfigProviderTest.avroSchema(0);
        schema = schema.copy(m, null);
        schemaRegistryClient.register("config", (ParsedSchema)schema);
        properties = new HashMap();
        properties.put("contextKey1", "contextValue1");
        properties.put("contextKey2", "contextValue2");
        properties.put("contextKey3", "contextValue3");
        m = new Metadata(Collections.emptyMap(), properties, null);
        schema = SchemaRegistryConfigProviderTest.avroSchema(1);
        schema = schema.copy(m, null);
        schemaRegistryClient.register(":.mycontext:config2", (ParsedSchema)schema);
    }

    @After
    public void close() throws IOException {
        this.provider.close();
    }

    @Test
    public void testGetAllKeysAtPath() {
        ConfigData configData = this.provider.get("subjects/config/versions/1");
        HashSet<String> keys = new HashSet<String>();
        keys.add("key1");
        keys.add("key2");
        keys.add("key3");
        Assert.assertEquals(keys, configData.data().keySet());
        Assert.assertEquals((Object)"value1", configData.data().get("key1"));
        Assert.assertEquals((Object)"value2", configData.data().get("key2"));
        Assert.assertEquals((Object)"value3", configData.data().get("key3"));
    }

    @Test
    public void testGetSetOfKeysAtPath() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("key1");
        ConfigData configData = this.provider.get("subjects/config/versions/1", keys);
        Assert.assertEquals(keys, configData.data().keySet());
        Assert.assertEquals((Object)"value1", configData.data().get("key1"));
    }

    @Test
    public void testGetAllKeysAtLatest() {
        ConfigData configData = this.provider.get("subjects/config/versions/latest");
        HashSet<String> keys = new HashSet<String>();
        keys.add("key1");
        keys.add("key2");
        keys.add("key3");
        Assert.assertEquals(keys, configData.data().keySet());
        Assert.assertEquals((Object)"value1", configData.data().get("key1"));
        Assert.assertEquals((Object)"value2", configData.data().get("key2"));
        Assert.assertEquals((Object)"value3", configData.data().get("key3"));
    }

    @Test
    public void testGetAllKeysAtContextPath() {
        ConfigData configData = this.provider.get("contexts/.mycontext/subjects/config2/versions/1");
        HashSet<String> keys = new HashSet<String>();
        keys.add("contextKey1");
        keys.add("contextKey2");
        keys.add("contextKey3");
        Assert.assertEquals(keys, configData.data().keySet());
        Assert.assertEquals((Object)"contextValue1", configData.data().get("contextKey1"));
        Assert.assertEquals((Object)"contextValue2", configData.data().get("contextKey2"));
        Assert.assertEquals((Object)"contextValue3", configData.data().get("contextKey3"));
    }

    @Test
    public void testGetSetOfKeysAtContextPath() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("contextKey1");
        ConfigData configData = this.provider.get("contexts/.mycontext/subjects/config2/versions/1", keys);
        Assert.assertEquals(keys, configData.data().keySet());
        Assert.assertEquals((Object)"contextValue1", configData.data().get("contextKey1"));
    }

    @Test
    public void testGetAllKeysAtContextLatest() {
        ConfigData configData = this.provider.get("contexts/.mycontext/subjects/config2/versions/latest");
        HashSet<String> keys = new HashSet<String>();
        keys.add("contextKey1");
        keys.add("contextKey2");
        keys.add("contextKey3");
        Assert.assertEquals(keys, configData.data().keySet());
        Assert.assertEquals((Object)"contextValue1", configData.data().get("contextKey1"));
        Assert.assertEquals((Object)"contextValue2", configData.data().get("contextKey2"));
        Assert.assertEquals((Object)"contextValue3", configData.data().get("contextKey3"));
    }

    @Test
    public void testEmptyPath() {
        ConfigData configData = this.provider.get("");
        Assert.assertTrue((boolean)configData.data().isEmpty());
    }

    @Test
    public void testEmptyPathWithKey() {
        ConfigData configData = this.provider.get("", Collections.singleton("key1"));
        Assert.assertTrue((boolean)configData.data().isEmpty());
    }

    @Test
    public void testNullPath() {
        ConfigData configData = this.provider.get(null);
        Assert.assertTrue((boolean)configData.data().isEmpty());
    }

    @Test
    public void testNullPathWithKey() {
        ConfigData configData = this.provider.get(null, Collections.singleton("key1"));
        Assert.assertTrue((boolean)configData.data().isEmpty());
    }

    @Test
    public void testServiceLoaderDiscovery() {
        ServiceLoader<ConfigProvider> serviceLoader = ServiceLoader.load(ConfigProvider.class);
        Assert.assertTrue((boolean)StreamSupport.stream(serviceLoader.spliterator(), false).anyMatch(configProvider -> configProvider instanceof SchemaRegistryConfigProvider));
    }

    private static AvroSchema avroSchema(int i) {
        return new AvroSchema(SchemaRegistryConfigProviderTest.avroSchemaString(i));
    }

    private static String avroSchemaString(int i) {
        return "{\"type\": \"record\", \"name\": \"Blah" + i + "\", \"fields\": [{ \"name\": \"name\", \"type\": \"string\" }]}";
    }
}

