/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaProvider.class);

    @Override
    public String schemaType() {
        return "AVRO";
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references) {
        try {
            return Optional.of(new AvroSchema(schemaString, references, this.resolveReferences(references), null));
        }
        catch (Exception e) {
            log.error("Could not parse Avro schema", (Throwable)e);
            return Optional.empty();
        }
    }
}

