/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RestService.class})
public class RestServiceTest {
    @Mock
    private URL url;

    @Test
    public void buildRequestUrl_trimNothing() {
        String baseUrl = "http://test.com";
        String path = "some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimBaseUrl() {
        String baseUrl = "http://test.com/";
        String path = "some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimPath() {
        String baseUrl = "http://test.com";
        String path = "/some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimBaseUrlAndPath() {
        String baseUrl = "http://test.com/";
        String path = "/some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void testSetBasicAuthRequestHeader() throws Exception {
        RestService restService = new RestService("http://localhost:8087");
        BasicAuthCredentialProvider basicAuthCredentialProvider = (BasicAuthCredentialProvider)EasyMock.createMock(BasicAuthCredentialProvider.class);
        restService.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
        HttpURLConnection httpURLConnection = (HttpURLConnection)EasyMock.createNiceMock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{EasyMock.anyString()}).andReturn((Object)this.url);
        EasyMock.expect((Object)this.url.openConnection()).andReturn((Object)httpURLConnection);
        EasyMock.expect((Object)httpURLConnection.getURL()).andReturn((Object)this.url);
        EasyMock.expect((Object)basicAuthCredentialProvider.getUserInfo((URL)EasyMock.anyObject(URL.class))).andReturn((Object)"user:password");
        EasyMock.expect((Object)httpURLConnection.getResponseCode()).andReturn((Object)200);
        httpURLConnection.setRequestProperty("Authorization", "Basic dXNlcjpwYXNzd29yZA==");
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)httpURLConnection.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andDelegateTo((Object)this.createInputStream("[\"abc\"]")).anyTimes();
        PowerMock.replay((Object[])new Object[]{URL.class, this.url});
        PowerMock.replay((Object[])new Object[]{HttpURLConnection.class, httpURLConnection});
        PowerMock.replay((Object[])new Object[]{basicAuthCredentialProvider});
        PowerMock.replay((Object[])new Object[]{InputStream.class, inputStream});
        restService.getAllSubjects();
        EasyMock.verify((Object[])new Object[]{httpURLConnection});
    }

    public void testSetBearerAuthRequestHeader() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        BearerAuthCredentialProvider bearerAuthCredentialProvider = (BearerAuthCredentialProvider)EasyMock.createMock(BearerAuthCredentialProvider.class);
        restService.setBearerAuthCredentialProvider(bearerAuthCredentialProvider);
        HttpURLConnection httpURLConnection = (HttpURLConnection)EasyMock.createNiceMock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{EasyMock.anyString()}).andReturn((Object)this.url);
        EasyMock.expect((Object)this.url.openConnection()).andReturn((Object)httpURLConnection);
        EasyMock.expect((Object)httpURLConnection.getURL()).andReturn((Object)this.url);
        EasyMock.expect((Object)bearerAuthCredentialProvider.getBearerToken((URL)EasyMock.anyObject(URL.class))).andReturn((Object)"auth-token");
        EasyMock.expect((Object)httpURLConnection.getResponseCode()).andReturn((Object)200);
        httpURLConnection.setRequestProperty("Authorization", "Bearer auth-token");
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)httpURLConnection.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andDelegateTo((Object)this.createInputStream("[\"abc\"]")).anyTimes();
        PowerMock.replay((Object[])new Object[]{URL.class, this.url});
        PowerMock.replay((Object[])new Object[]{HttpURLConnection.class, httpURLConnection});
        PowerMock.replay((Object[])new Object[]{bearerAuthCredentialProvider});
        PowerMock.replay((Object[])new Object[]{InputStream.class, inputStream});
        restService.getAllSubjects();
        EasyMock.verify((Object[])new Object[]{httpURLConnection});
    }

    @Test
    public void testSetHttpHeaders() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        BasicAuthCredentialProvider basicAuthCredentialProvider = (BasicAuthCredentialProvider)EasyMock.createMock(BasicAuthCredentialProvider.class);
        restService.setHttpHeaders((Map)ImmutableMap.of((Object)"api-key", (Object)"test-api-key", (Object)"source-app", (Object)"foo"));
        HttpURLConnection httpURLConnection = (HttpURLConnection)EasyMock.createNiceMock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{EasyMock.anyString()}).andReturn((Object)this.url);
        EasyMock.expect((Object)this.url.openConnection()).andReturn((Object)httpURLConnection);
        EasyMock.expect((Object)httpURLConnection.getResponseCode()).andReturn((Object)200);
        httpURLConnection.setRequestProperty("api-key", "test-api-key");
        httpURLConnection.setRequestProperty("source-app", "foo");
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)httpURLConnection.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andDelegateTo((Object)this.createInputStream("[\"abc\"]")).anyTimes();
        PowerMock.replay((Object[])new Object[]{URL.class, this.url});
        PowerMock.replay((Object[])new Object[]{HttpURLConnection.class, httpURLConnection});
        PowerMock.replay((Object[])new Object[]{InputStream.class, inputStream});
        restService.getAllSubjects();
        EasyMock.verify((Object[])new Object[]{httpURLConnection});
    }

    @Test
    public void testErrorResponseWithNullErrorStreamFromConnection() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        HttpURLConnection httpURLConnection = (HttpURLConnection)EasyMock.createNiceMock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{EasyMock.anyString()}).andReturn((Object)this.url);
        EasyMock.expect((Object)this.url.openConnection()).andReturn((Object)httpURLConnection);
        EasyMock.expect((Object)httpURLConnection.getResponseCode()).andReturn((Object)400);
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)httpURLConnection.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)httpURLConnection.getErrorStream()).andReturn(null);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andDelegateTo((Object)this.createInputStream("[\"abc\"]")).anyTimes();
        PowerMock.replay((Object[])new Object[]{URL.class, this.url});
        PowerMock.replay((Object[])new Object[]{HttpURLConnection.class, httpURLConnection});
        PowerMock.replay((Object[])new Object[]{InputStream.class, inputStream});
        try {
            restService.getAllSubjects();
            Assert.fail((String)"Expected RestClientException to be thrown");
        }
        catch (RestClientException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("error code: 50005"));
        }
    }

    @Test
    public void testSetProxy() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        HttpURLConnection httpURLConnection = (HttpURLConnection)EasyMock.createNiceMock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("proxy.host", "http://localhost");
        configs.put("proxy.port", 8080);
        restService.configure(configs);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{EasyMock.anyString()}).andReturn((Object)this.url);
        EasyMock.expect((Object)this.url.openConnection(RestServiceTest.withProxy())).andReturn((Object)httpURLConnection);
        EasyMock.expect((Object)httpURLConnection.getResponseCode()).andReturn((Object)200);
        EasyMock.expect((Object)httpURLConnection.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andDelegateTo((Object)this.createInputStream("[\"abc\"]")).anyTimes();
        PowerMock.replay((Object[])new Object[]{URL.class, this.url});
        PowerMock.replay((Object[])new Object[]{HttpURLConnection.class, httpURLConnection});
        PowerMock.replay((Object[])new Object[]{InputStream.class, inputStream});
        restService.getAllSubjects();
        EasyMock.verify((Object[])new Object[]{httpURLConnection});
    }

    private ByteArrayInputStream createInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    private static Proxy withProxy() {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){
            private final String proxyHost = "http://localhost";
            private final int proxyPort = 8080;

            public boolean matches(Object proxyObj) {
                Proxy proxy;
                SocketAddress socketAddress;
                if (proxyObj instanceof Proxy && (socketAddress = (proxy = (Proxy)proxyObj).address()) instanceof InetSocketAddress) {
                    InetSocketAddress inetAddress = (InetSocketAddress)socketAddress;
                    return inetAddress.getHostName().equals("http://localhost") && inetAddress.getPort() == 8080;
                }
                return false;
            }

            public void appendTo(StringBuffer stringBuffer) {
                stringBuffer.append("HTTP @ ").append("http://localhost").append(":").append(8080);
            }
        });
        return null;
    }
}

