/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mapr.security.client.ClientSecurity;
import com.mapr.security.client.MapRClientSecurityException;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static final TypeReference<RegisterSchemaResponse> REGISTER_RESPONSE_TYPE = new TypeReference<RegisterSchemaResponse>(){};
    private static final TypeReference<Config> GET_CONFIG_RESPONSE_TYPE = new TypeReference<Config>(){};
    private static final TypeReference<SchemaString> GET_SCHEMA_BY_ID_RESPONSE_TYPE = new TypeReference<SchemaString>(){};
    private static final TypeReference<JsonNode> GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE = new TypeReference<JsonNode>(){};
    private static final TypeReference<Schema> GET_SCHEMA_BY_VERSION_RESPONSE_TYPE = new TypeReference<Schema>(){};
    private static final TypeReference<List<Integer>> ALL_VERSIONS_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<String>> ALL_TOPICS_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<CompatibilityCheckResponse> COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE = new TypeReference<CompatibilityCheckResponse>(){};
    private static final TypeReference<Schema> SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE = new TypeReference<Schema>(){};
    private static final TypeReference<ConfigUpdateRequest> UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE = new TypeReference<ConfigUpdateRequest>(){};
    private static final TypeReference<Integer> DELETE_SUBJECT_VERSION_RESPONSE_TYPE = new TypeReference<Integer>(){};
    private static final TypeReference<? extends List<Integer>> DELETE_SUBJECT_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final int HTTP_CONNECT_TIMEOUT_MS = 60000;
    private static final int HTTP_READ_TIMEOUT_MS = 60000;
    private static final int JSON_PARSE_ERROR_CODE = 50005;
    private static ObjectMapper jsonDeserializer = new ObjectMapper();
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = new HashMap<String, String>();
    private UrlList baseUrls;
    private SSLSocketFactory sslSocketFactory;
    private BasicAuthCredentialProvider basicAuthCredentialProvider;
    private boolean maprSaslAuth = false;
    private String authCookie;

    public RestService(UrlList baseUrls) {
        this.baseUrls = baseUrls;
    }

    public RestService(List<String> baseUrls) {
        this(new UrlList(baseUrls));
    }

    public RestService(String baseUrlConfig) {
        this(RestService.parseBaseUrl(baseUrlConfig));
    }

    public static String readChallengeString() {
        ClientSecurity cs = new ClientSecurity();
        try {
            return cs.generateChallenge();
        }
        catch (MapRClientSecurityException e) {
            throw new RuntimeException("Cannot read chalange string", e);
        }
    }

    public void setMaprSaslAuth(Boolean maprSaslAuth) {
        this.maprSaslAuth = maprSaslAuth != null && maprSaslAuth != false;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T sendHttpRequest(String requestUrl, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        String requestData = requestBodyData == null ? "null" : new String(requestBodyData, StandardCharsets.UTF_8);
        log.debug(String.format("Sending %s with input %s to %s", method, requestData, requestUrl));
        HttpURLConnection connection = null;
        try {
            T t;
            int responseCode;
            URL url = new URL(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            this.setupSsl(connection);
            connection.setRequestMethod(method);
            this.setAuthRequestHeaderOrCookie(connection);
            connection.setDoInput(true);
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setUseCaches(false);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                try (OutputStream os = null;){
                    os = connection.getOutputStream();
                    os.write(requestBodyData);
                    os.flush();
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                this.extractAuthCookieFromResponse(connection);
                InputStream is = connection.getInputStream();
                Object result = jsonDeserializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                t = null;
                return t;
            }
            t = this.handleBadResponse(connection);
            return t;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private <T> T handleBadResponse(HttpURLConnection connection) throws IOException, RestClientException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 401 || responseCode == 403) {
            throw new RestClientException(connection.getResponseMessage(), responseCode, responseCode);
        }
        try {
            InputStream es = connection.getErrorStream();
            Throwable throwable = null;
            try {
                try {
                    ErrorMessage errorMessage = (ErrorMessage)jsonDeserializer.readValue(es, ErrorMessage.class);
                    throw new RestClientException(errorMessage.getMessage(), responseCode, errorMessage.getErrorCode());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (es != null) {
                    if (throwable != null) {
                        try {
                            es.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        es.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (JsonProcessingException e) {
            throw new RestClientException(e.getMessage(), responseCode, 50005);
        }
    }

    private void setupSsl(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    private <T> T httpRequest(String path, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        int n = this.baseUrls.size();
        for (int i = 0; i < n; ++i) {
            String baseUrl = this.baseUrls.current();
            String requestUrl = RestService.buildRequestUrl(baseUrl, path);
            try {
                try {
                    return this.sendHttpRequest(requestUrl, method, requestBodyData, requestProperties, responseFormat);
                }
                catch (RestClientException e) {
                    if (e.getStatus() == 401 && this.authCookie != null) {
                        this.authCookie = null;
                        return this.sendHttpRequest(requestUrl, method, requestBodyData, requestProperties, responseFormat);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                this.baseUrls.fail(baseUrl);
                if (i != n - 1) continue;
                throw e;
            }
        }
        throw new IOException("Internal HTTP retry error");
    }

    static String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(request, subject);
    }

    public Schema lookUpSubjectVersion(RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, false);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s", subject);
        if (requestProperties.isEmpty()) {
            requestProperties = DEFAULT_REQUEST_PROPERTIES;
        }
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, request, subject, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        String path = String.format("/subjects/%s?deleted=%s", subject, lookupDeletedSchema);
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public int registerSchema(String schemaString, String subject) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.registerSchema(request, subject);
    }

    public int registerSchema(RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        return this.registerSchema(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject);
    }

    public int registerSchema(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions", subject);
        RegisterSchemaResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, REGISTER_RESPONSE_TYPE);
        return response.getId();
    }

    public boolean testCompatibility(String schemaString, String subject, String version) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.testCompatibility(request, subject, version);
    }

    public boolean testCompatibility(RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        return this.testCompatibility(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, version);
    }

    public boolean testCompatibility(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        String path = String.format("/compatibility/subjects/%s/versions/%s", subject, version);
        CompatibilityCheckResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE);
        return response.getIsCompatible();
    }

    public ConfigUpdateRequest updateCompatibility(String compatibility, String subject) throws IOException, RestClientException {
        ConfigUpdateRequest request = new ConfigUpdateRequest();
        request.setCompatibilityLevel(compatibility);
        return this.updateConfig(request, subject);
    }

    public ConfigUpdateRequest updateConfig(ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        return this.updateConfig(DEFAULT_REQUEST_PROPERTIES, configUpdateRequest, subject);
    }

    public ConfigUpdateRequest updateConfig(Map<String, String> requestProperties, ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/config/%s", subject) : "/config";
        ConfigUpdateRequest response = this.httpRequest(path, "PUT", configUpdateRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public Config getConfig(String subject) throws IOException, RestClientException {
        return this.getConfig(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Config getConfig(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/config/%s", subject) : "/config";
        Config config = this.httpRequest(path, "GET", null, requestProperties, GET_CONFIG_RESPONSE_TYPE);
        return config;
    }

    public SchemaString getId(int id) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        String path = String.format("/schemas/ids/%d", id);
        SchemaString response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_ID_RESPONSE_TYPE);
        return response;
    }

    public Schema getVersion(String subject, int version) throws IOException, RestClientException {
        return this.getVersion(DEFAULT_REQUEST_PROPERTIES, subject, version);
    }

    public Schema getVersion(Map<String, String> requestProperties, String subject, int version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%d", subject, version);
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public Schema getLatestVersion(String subject) throws IOException, RestClientException {
        return this.getLatestVersion(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Schema getLatestVersion(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/latest", subject);
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public String getVersionSchemaOnly(String subject, int version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%d/schema", subject, version);
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public String getLatestVersionSchemaOnly(String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/latest/schema", subject);
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.getAllVersions(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public List<Integer> getAllVersions(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions", subject);
        List<Integer> response = this.httpRequest(path, "GET", null, requestProperties, ALL_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getAllSubjects() throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> getAllSubjects(Map<String, String> requestProperties) throws IOException, RestClientException {
        List<String> response = this.httpRequest("/subjects", "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%s", subject, version);
        Integer response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_VERSION_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s", subject);
        List<Integer> response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_RESPONSE_TYPE);
        return response;
    }

    private static List<String> parseBaseUrl(String baseUrl) {
        List<String> baseUrls = Arrays.asList(baseUrl.split("\\s*,\\s*"));
        if (baseUrls.isEmpty()) {
            throw new IllegalArgumentException("Missing required schema registry url list");
        }
        return baseUrls;
    }

    public UrlList getBaseUrls() {
        return this.baseUrls;
    }

    private void extractAuthCookieFromResponse(HttpURLConnection connection) {
        Optional<String> hadoopAuth = Optional.ofNullable(connection.getHeaderField("Set-Cookie"));
        hadoopAuth.ifPresent(value -> {
            if (value.startsWith("hadoop.auth")) {
                this.authCookie = value;
            }
        });
    }

    private void setAuthRequestHeaderOrCookie(HttpURLConnection connection) {
        String userInfo;
        if (this.authCookie != null) {
            connection.setRequestProperty("Cookie", this.authCookie);
            return;
        }
        if (this.basicAuthCredentialProvider != null && (userInfo = this.basicAuthCredentialProvider.getUserInfo(connection.getURL())) != null) {
            String authHeader = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + authHeader);
            return;
        }
        if (this.maprSaslAuth) {
            String maprSaslChallengeString = RestService.readChallengeString();
            connection.setRequestProperty("Authorization", String.format("MAPR-Negotiate %s", maprSaslChallengeString));
        }
    }

    public void setBasicAuthCredentialProvider(BasicAuthCredentialProvider basicAuthCredentialProvider) {
        this.basicAuthCredentialProvider = basicAuthCredentialProvider;
    }

    static {
        DEFAULT_REQUEST_PROPERTIES.put("Content-Type", "application/vnd.schemaregistry.v1+json");
    }
}

