/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.easymock.annotation.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RestService.class})
public class RestServiceTest {
    @Mock
    private URL url;

    @Test
    public void buildRequestUrl_trimNothing() {
        String baseUrl = "http://test.com";
        String path = "some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimBaseUrl() {
        String baseUrl = "http://test.com/";
        String path = "some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimPath() {
        String baseUrl = "http://test.com";
        String path = "/some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimBaseUrlAndPath() {
        String baseUrl = "http://test.com/";
        String path = "/some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void testSetBasicAuthRequestHeader() throws Exception {
        RestService restService = new RestService("http://localhost:8087");
        BasicAuthCredentialProvider basicAuthCredentialProvider = (BasicAuthCredentialProvider)EasyMock.createMock(BasicAuthCredentialProvider.class);
        restService.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
        HttpURLConnection httpURLConnection = (HttpURLConnection)EasyMock.createNiceMock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        PowerMock.expectNew(URL.class, (Object[])new Object[]{EasyMock.anyString()}).andReturn((Object)this.url);
        EasyMock.expect((Object)this.url.openConnection()).andReturn((Object)httpURLConnection);
        EasyMock.expect((Object)httpURLConnection.getURL()).andReturn((Object)this.url);
        EasyMock.expect((Object)basicAuthCredentialProvider.getUserInfo((URL)EasyMock.anyObject(URL.class))).andReturn((Object)"user:password");
        EasyMock.expect((Object)httpURLConnection.getResponseCode()).andReturn((Object)200);
        httpURLConnection.setRequestProperty("Authorization", "Basic dXNlcjpwYXNzd29yZA==");
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)httpURLConnection.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andDelegateTo((Object)new InputStream(){

            @Override
            public int read() {
                return 0;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                byte[] json = "[\"abc\"]".getBytes(StandardCharsets.UTF_8);
                System.arraycopy(json, 0, b, 0, json.length);
                return json.length;
            }
        }).anyTimes();
        PowerMock.replay((Object[])new Object[]{URL.class, this.url});
        PowerMock.replay((Object[])new Object[]{HttpURLConnection.class, httpURLConnection});
        PowerMock.replay((Object[])new Object[]{basicAuthCredentialProvider});
        PowerMock.replay((Object[])new Object[]{InputStream.class, inputStream});
        restService.getAllSubjects();
        EasyMock.verify((Object[])new Object[]{httpURLConnection});
    }
}

