/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachedSchemaRegistryClientTest {
    private static final int IDENTITY_MAP_CAPACITY = 5;
    private static final String SCHEMA_STR_0 = CachedSchemaRegistryClientTest.avroSchemaString(0);
    private static final org.apache.avro.Schema AVRO_SCHEMA_0 = CachedSchemaRegistryClientTest.avroSchema(0);
    private static final String SUBJECT_0 = "foo";
    private static final int ID_25 = 25;
    private static final Schema SCHEMA_DETAILS = new Schema("foo", Integer.valueOf(7), Integer.valueOf(25), SCHEMA_STR_0);
    private RestService restService;

    @Before
    public void setUp() {
        this.restService = (RestService)EasyMock.createNiceMock(RestService.class);
    }

    private CachedSchemaRegistryClient createSchemaRegistryClient() {
        return new CachedSchemaRegistryClient(this.restService, 5, new HashMap());
    }

    @Test
    public void testRegisterSchemaCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)25).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterOverCapacity() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)25).andReturn((Object)26).andReturn((Object)27).andReturn((Object)28).andReturn((Object)29);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        for (int i = 0; i != 5; ++i) {
            client.register(SUBJECT_0, CachedSchemaRegistryClientTest.avroSchema(i));
        }
        try {
            client.register(SUBJECT_0, CachedSchemaRegistryClientTest.avroSchema(5));
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testIdCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)25);
        EasyMock.expect((Object)this.restService.getId(25)).andReturn((Object)new SchemaString(SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((Object)AVRO_SCHEMA_0, (Object)client.getBySubjectAndId(SUBJECT_0, 25));
        Assert.assertEquals((Object)AVRO_SCHEMA_0, (Object)client.getBySubjectAndId(SUBJECT_0, 25));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testVersionCache() throws Exception {
        int version = 7;
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)25);
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.eq((boolean)true))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, AVRO_SCHEMA_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testIdenticalSchemas() throws Exception {
        SchemaString schemaStringOne = new SchemaString(SCHEMA_STR_0);
        SchemaString schemaStringTwo = new SchemaString(SCHEMA_STR_0);
        String subjectOne = "subjectOne";
        String subjectTwo = "subjectTwo";
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)subjectOne))).andReturn((Object)25);
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)subjectTwo))).andReturn((Object)25);
        EasyMock.expect((Object)this.restService.getId(EasyMock.eq((int)25))).andReturn((Object)schemaStringOne);
        EasyMock.expect((Object)this.restService.getId(EasyMock.eq((int)25))).andReturn((Object)schemaStringTwo);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(subjectOne, AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)client.register(subjectTwo, AVRO_SCHEMA_0));
        Assert.assertEquals((Object)AVRO_SCHEMA_0, (Object)client.getBySubjectAndId(subjectOne, 25));
        Assert.assertEquals((Object)AVRO_SCHEMA_0, (Object)client.getBySubjectAndId(subjectTwo, 25));
        Assert.assertEquals((Object)AVRO_SCHEMA_0, (Object)client.getBySubjectAndId(subjectOne, 25));
        Assert.assertEquals((Object)AVRO_SCHEMA_0, (Object)client.getBySubjectAndId(subjectTwo, 25));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteSchemaCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)25).once();
        EasyMock.expect((Object)this.restService.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0)).andReturn(Arrays.asList(0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals(Arrays.asList(0), (Object)client.deleteSubject(SUBJECT_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteVersionCache() throws Exception {
        int version = 7;
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)25);
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.eq((boolean)true))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), SCHEMA_STR_0));
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, String.valueOf(version))).andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, AVRO_SCHEMA_0));
        Assert.assertEquals((Object)0, (Object)client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version)));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteVersionNotInVersionCache() throws Exception {
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(Collections.emptyMap(), SUBJECT_0, "0")).andReturn((Object)10);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Integer result = client.deleteSchemaVersion(Collections.emptyMap(), SUBJECT_0, "0");
        Assert.assertEquals((Object)10, (Object)result);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteNullSubjectThrows() throws Exception {
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        client.deleteSubject(null);
    }

    @Test
    public void testThreadSafe() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema(EasyMock.anyString(), (String)EasyMock.eq((Object)SUBJECT_0))).andReturn((Object)25).anyTimes();
        EasyMock.expect((Object)this.restService.getId(25)).andReturn((Object)new SchemaString(SCHEMA_STR_0)).anyTimes();
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((String)EasyMock.eq((Object)AVRO_SCHEMA_0.toString()), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)SCHEMA_DETAILS).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        IntStream.range(0, 1000).parallel().forEach(idx -> {
            try {
                int id = client.register(SUBJECT_0, AVRO_SCHEMA_0);
                int version = client.getVersion(SUBJECT_0, AVRO_SCHEMA_0);
                client.getId(SUBJECT_0, AVRO_SCHEMA_0);
                client.getBySubjectAndId(SUBJECT_0, id);
                client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version));
                client.deleteSubject(SUBJECT_0);
            }
            catch (RestClientException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static org.apache.avro.Schema avroSchema(int i) {
        return new Schema.Parser().parse(CachedSchemaRegistryClientTest.avroSchemaString(i));
    }

    private static String avroSchemaString(int i) {
        return "{\"type\": \"record\", \"name\": \"Blah" + i + "\", \"fields\": [{ \"name\": \"name\", \"type\": \"string\" }]}";
    }
}

