/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import io.confluent.common.config.AbstractConfig;
import io.confluent.common.config.ConfigDef;
import io.confluent.kafka.schemaregistry.client.rest.utils.SchemaRegistryDiscoveryClient;
import org.apache.commons.lang3.StringUtils;

public class SchemaRegistryDiscoveryConfig {
    public static final String SERVICE_ID_CONFIG = "schema.registry.service.id";
    public static final String SERVICE_ID_DEFAULT = "default_";
    public static final String SERVICE_ID_DOC = "Indicates the ID of the schema registry service.";
    public static final String DISCOVERY_TIMEOUT_CONFIG = "schema.registry.discovery.timeout";
    public static final int DISCOVERY_TIMEOUT_DEFAULT = 60000;
    public static final String DISCOVERY_TIMEOUT_DOC = "The timeout in milliseconds for request to Schema Registry URL storage.";
    public static final String DISCOVERY_RETRIES_CONFIG = "schema.registry.discovery.retries";
    public static final int DISCOVERY_RETRIES_DEFAULT = 6;
    public static final String DISCOVERY_RETRIES_DOC = "The number of retries for Schema Registry URL discovery.";
    public static final String DISCOVERY_INTERVAL_CONFIG = "schema.registry.discovery.interval";
    public static final int DISCOVERY_INTERVAL_DEFAULT = 15000;
    public static final String DISCOVERY_INTERVAL_DOC = "The interval in milliseconds between retries for Schema Registry URL discovery.";

    public static ConfigDef defineDiscoveryProperties(ConfigDef configDef) {
        return SchemaRegistryDiscoveryConfig.defineDiscoveryProperties(configDef, "");
    }

    public static ConfigDef defineDiscoveryProperties(ConfigDef configDef, String prefix) {
        prefix = SchemaRegistryDiscoveryConfig.prefixOrEmpty(prefix);
        return configDef.define(prefix + SERVICE_ID_CONFIG, ConfigDef.Type.STRING, (Object)SERVICE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, SERVICE_ID_DOC).define(prefix + DISCOVERY_TIMEOUT_CONFIG, ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.MEDIUM, DISCOVERY_TIMEOUT_DOC).define(prefix + DISCOVERY_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)6, ConfigDef.Importance.MEDIUM, DISCOVERY_RETRIES_DOC).define(prefix + DISCOVERY_INTERVAL_CONFIG, ConfigDef.Type.INT, (Object)15000, ConfigDef.Importance.MEDIUM, DISCOVERY_INTERVAL_DOC);
    }

    private static String prefixOrEmpty(String prefix) {
        return prefix.isEmpty() ? "" : StringUtils.appendIfMissing((String)prefix, (CharSequence)".", (CharSequence[])new CharSequence[0]);
    }

    public static SchemaRegistryDiscoveryClient configureDiscoveryClient(AbstractConfig config) {
        return SchemaRegistryDiscoveryConfig.configureDiscoveryClient(config, "");
    }

    public static SchemaRegistryDiscoveryClient configureDiscoveryClient(AbstractConfig config, String prefix) {
        prefix = SchemaRegistryDiscoveryConfig.prefixOrEmpty(prefix);
        return new SchemaRegistryDiscoveryClient().serviceId(config.getString(prefix + SERVICE_ID_CONFIG)).timeout(config.getInt(prefix + DISCOVERY_TIMEOUT_CONFIG)).retries(config.getInt(prefix + DISCOVERY_RETRIES_CONFIG)).retryInterval(config.getInt(prefix + DISCOVERY_INTERVAL_CONFIG));
    }
}

