/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.basicauth;

import io.confluent.common.config.ConfigException;
import io.confluent.kafka.schemaregistry.client.security.basicauth.UserInfoCredentialProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UserInfoCredentialProviderTest {
    @Parameterized.Parameter
    public String userInfoConfigName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"basic.auth.user.info"}, {"schema.registry.basic.auth.user.info"});
    }

    @Test
    public void testUserInfo() throws MalformedURLException {
        HashMap<String, String> clientConfig = new HashMap<String, String>();
        clientConfig.put(this.userInfoConfigName, "user:password");
        UserInfoCredentialProvider provider = new UserInfoCredentialProvider();
        provider.configure(clientConfig);
        Assert.assertEquals((Object)"user:password", (Object)provider.getUserInfo(new URL("http://localhost")));
    }

    @Test(expected=ConfigException.class)
    public void testNullUserInfo() throws MalformedURLException {
        HashMap clientConfig = new HashMap();
        UserInfoCredentialProvider provider = new UserInfoCredentialProvider();
        provider.configure(clientConfig);
    }
}

