/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.DekRegistryClientFactory;
import io.confluent.dekregistry.client.MockDekRegistryClientFactory;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionExecutor;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import io.confluent.kafka.schemaregistry.encryption.tink.Cryptor;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rules.WidgetBytesProto;
import io.confluent.kafka.schemaregistry.rules.WidgetProto;
import io.confluent.kafka.schemaregistry.testutil.FakeClock;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"javax.crypto.*"})
@PrepareForTest(value={UserGroupInformation.class})
@RunWith(value=PowerMockRunner.class)
@SuppressStaticInitializationFor(value={"com.mapr.baseutils.JVMProperties"})
public abstract class FieldEncryptionExecutorTest {
    private final FieldEncryptionProperties fieldEncryptionProps;
    private final SchemaRegistryClient schemaRegistry;
    private final DekRegistryClient dekRegistry;
    private final KafkaAvroSerializer avroSerializer;
    private final KafkaAvroDeserializer avroDeserializer;
    private final KafkaAvroSerializer avroKeySerializer;
    private final KafkaAvroDeserializer avroKeyDeserializer;
    private final KafkaAvroSerializer avroValueSerializer;
    private final KafkaAvroDeserializer avroValueDeserializer;
    private final KafkaAvroSerializer avroSerializerWithoutKey;
    private final KafkaAvroDeserializer avroDeserializerWithoutKey;
    private final KafkaAvroSerializer reflectionAvroSerializer;
    private final KafkaAvroDeserializer reflectionAvroDeserializer;
    private final KafkaJsonSchemaSerializer<OldWidget> jsonSchemaSerializer;
    private final KafkaJsonSchemaSerializer<AnnotatedOldWidget> jsonSchemaSerializer2;
    private final KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer;
    private final KafkaProtobufSerializer<WidgetProto.Widget> protobufSerializer;
    private final KafkaProtobufSerializer<WidgetBytesProto.WidgetBytes> protobufSerializerBytes;
    private final KafkaProtobufDeserializer<DynamicMessage> protobufDeserializer;
    private final KafkaAvroSerializer badSerializer;
    private final KafkaAvroDeserializer badDeserializer;
    private final KafkaAvroSerializer goodDekSerializer;
    private final KafkaAvroSerializer badDekSerializer;
    private final String topic;
    private final FakeClock fakeClock = new FakeClock();

    public FieldEncryptionExecutorTest() throws Exception {
        this.topic = "test";
        ImmutableList ruleNames = ImmutableList.of((Object)"rule1", (Object)"rule2");
        this.fieldEncryptionProps = this.getFieldEncryptionProperties((List<String>)ruleNames, FieldEncryptionExecutor.class);
        Map<String, Object> clientProps = this.fieldEncryptionProps.getClientProperties("mock://");
        clientProps.put("clock", this.fakeClock);
        this.schemaRegistry = SchemaRegistryClientFactory.newClient(Collections.singletonList("mock://"), (int)1000, (List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()), null, null);
        this.dekRegistry = DekRegistryClientFactory.newClient(Collections.singletonList("mock://"), (int)1000, (int)100000, Collections.singletonMap("test.client", this.fieldEncryptionProps.getTestClient()), null);
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, clientProps);
        this.avroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, clientProps);
        ImmutableList qualifiedRuleNames = ImmutableList.of((Object)"test-key:rule1", (Object)"test-value:rule1");
        FieldEncryptionProperties qualifiedFieldEncryptionProps = this.getFieldEncryptionProperties((List<String>)qualifiedRuleNames, FieldEncryptionExecutor.class);
        Map<String, Object> qualifiedClientProps = qualifiedFieldEncryptionProps.getClientProperties("mock://");
        this.avroKeySerializer = new KafkaAvroSerializer();
        this.avroKeySerializer.configure(qualifiedClientProps, true);
        this.avroKeyDeserializer = new KafkaAvroDeserializer();
        this.avroKeyDeserializer.configure(qualifiedClientProps, true);
        this.avroValueSerializer = new KafkaAvroSerializer();
        this.avroValueSerializer.configure(qualifiedClientProps, false);
        this.avroValueDeserializer = new KafkaAvroDeserializer();
        this.avroValueDeserializer.configure(qualifiedClientProps, false);
        Map<String, Object> clientPropsWithoutKey = this.fieldEncryptionProps.getClientProperties("mock://");
        this.avroSerializerWithoutKey = new KafkaAvroSerializer(this.schemaRegistry, clientPropsWithoutKey);
        this.avroDeserializerWithoutKey = new KafkaAvroDeserializer(this.schemaRegistry, clientPropsWithoutKey);
        HashMap<String, Object> reflectionClientProps = new HashMap<String, Object>(clientProps);
        reflectionClientProps.put("schema.reflection", "true");
        this.reflectionAvroSerializer = new KafkaAvroSerializer(this.schemaRegistry, reflectionClientProps);
        this.reflectionAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, reflectionClientProps);
        this.jsonSchemaSerializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, clientProps);
        this.jsonSchemaSerializer2 = new KafkaJsonSchemaSerializer(this.schemaRegistry, clientProps);
        this.jsonSchemaDeserializer = new KafkaJsonSchemaDeserializer(this.schemaRegistry, clientProps);
        this.protobufSerializer = new KafkaProtobufSerializer(this.schemaRegistry, clientProps);
        this.protobufSerializerBytes = new KafkaProtobufSerializer(this.schemaRegistry, clientProps);
        this.protobufDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, clientProps);
        HashMap<String, Object> badClientProps = new HashMap<String, Object>(clientProps);
        badClientProps.remove("rule.executors");
        badClientProps.put("rule.service.loader.enable", false);
        this.badSerializer = new KafkaAvroSerializer(this.schemaRegistry, badClientProps);
        this.badDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, badClientProps);
        FieldEncryptionProperties goodDekProps = this.getFieldEncryptionProperties((List<String>)ruleNames, GoodDekGenerator.class);
        Map<String, Object> goodDekClientProps = goodDekProps.getClientProperties("mock://");
        this.goodDekSerializer = new KafkaAvroSerializer(this.schemaRegistry, goodDekClientProps);
        FieldEncryptionProperties badDekProps = this.getFieldEncryptionProperties((List<String>)ruleNames, BadDekGenerator.class);
        Map<String, Object> badDekClientProps = badDekProps.getClientProperties("mock://");
        this.badDekSerializer = new KafkaAvroSerializer(this.schemaRegistry, badDekClientProps);
    }

    protected abstract FieldEncryptionProperties getFieldEncryptionProperties(List<String> var1, Class<?> var2);

    private Cryptor addSpyToCryptor(AbstractKafkaSchemaSerDe serde) throws Exception {
        return this.addSpyToCryptor(serde, DekFormat.AES256_GCM);
    }

    private Cryptor addSpyToCryptor(AbstractKafkaSchemaSerDe serde, DekFormat dekFormat) throws Exception {
        Map executors = serde.getRuleExecutors();
        Map executorsByType = (Map)executors.get("ENCRYPT");
        FieldEncryptionExecutor executor = null;
        if (executorsByType != null && !executorsByType.isEmpty()) {
            executor = (FieldEncryptionExecutor)executorsByType.entrySet().iterator().next().getValue();
        }
        if (executor != null) {
            Map cryptors = executor.getCryptors();
            Cryptor spy = (Cryptor)Mockito.spy((Object)new Cryptor(dekFormat));
            cryptors.put(dekFormat, spy);
            return spy;
        }
        return null;
    }

    private Cryptor addSpyToCryptor(AbstractKafkaSchemaSerDe serde, String name) throws Exception {
        return this.addSpyToCryptor(serde, name, DekFormat.AES256_GCM);
    }

    private Cryptor addSpyToCryptor(AbstractKafkaSchemaSerDe serde, String name, DekFormat dekFormat) throws Exception {
        Map executors = serde.getRuleExecutors();
        Map executorsByType = (Map)executors.get("ENCRYPT");
        FieldEncryptionExecutor executor = null;
        if (executorsByType != null && !executorsByType.isEmpty()) {
            executor = (FieldEncryptionExecutor)((Map)executors.get("ENCRYPT")).get(name);
        }
        if (executor == null) {
            FieldEncryptionExecutor encryptor;
            executor = encryptor = (FieldEncryptionExecutor)((Map)executors.get("ENCRYPT")).get("_default_");
        }
        if (executor != null) {
            Map cryptors = executor.getCryptors();
            Cryptor cryptor = (Cryptor)cryptors.get(dekFormat);
            if (cryptor != null) {
                return cryptor;
            }
            Cryptor spy = (Cryptor)Mockito.spy((Object)new Cryptor(dekFormat));
            cryptors.put(dekFormat, spy);
            return spy;
        }
        return null;
    }

    private Cryptor addBadSpyToCryptor(AbstractKafkaSchemaSerDe serde) throws Exception {
        return this.addBadSpyToCryptor(serde, DekFormat.AES256_GCM);
    }

    private Cryptor addBadSpyToCryptor(AbstractKafkaSchemaSerDe serde, DekFormat dekFormat) throws Exception {
        Map executors = serde.getRuleExecutors();
        FieldEncryptionExecutor executor = (FieldEncryptionExecutor)((Map)executors.get("ENCRYPT")).entrySet().iterator().next().getValue();
        if (executor != null) {
            Map cryptors = executor.getCryptors();
            Cryptor spy = (Cryptor)Mockito.spy((Object)new Cryptor(dekFormat));
            ((Cryptor)Mockito.doThrow((Throwable[])new Throwable[]{new GeneralSecurityException()}).when((Object)spy)).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.doThrow((Throwable[])new Throwable[]{new GeneralSecurityException()}).when((Object)spy)).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            cryptors.put(dekFormat, spy);
            return spy;
        }
        return null;
    }

    private Schema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII\", \"PII3\"]},{\"name\": \"name2\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII2\"]},{\"name\": \"age\", \"type\": [\"null\", \"int\"]}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private GenericRecord createUserRecord() {
        Schema schema = this.createUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        avroRecord.put("name2", (Object)"testUser2");
        avroRecord.put("age", (Object)18);
        return avroRecord;
    }

    private Schema createUserSchemaWithTaggedInt() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII\", \"PII3\"]},{\"name\": \"name2\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII2\"]},{\"name\": \"age\", \"type\": [\"null\", \"int\"], \"confluent:tags\": [\"PII\"]}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private IndexedRecord createUserRecordWithTaggedInt() {
        Schema schema = this.createUserSchemaWithTaggedInt();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        avroRecord.put("name2", (Object)"testUser2");
        avroRecord.put("age", (Object)18);
        return avroRecord;
    }

    private Schema createUserBytesSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": [\"null\", \"bytes\"], \"confluent:tags\": [\"PII\", \"PII3\"]},{\"name\": \"name2\", \"type\": [\"null\", \"bytes\"], \"confluent:tags\": [\"PII2\"]}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private IndexedRecord createUserBytesRecord() {
        Schema schema = this.createUserBytesSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)ByteBuffer.wrap("testUser".getBytes(StandardCharsets.UTF_8)));
        avroRecord.put("name2", (Object)ByteBuffer.wrap("testUser2".getBytes(StandardCharsets.UTF_8)));
        return avroRecord;
    }

    private Schema createWidgetSchema() {
        String userSchema = "{\"type\":\"record\",\"name\":\"OldWidget\",\"namespace\":\"io.confluent.kafka.schemaregistry.encryption.FieldEncryptionExecutorTest\",\"fields\":\n[{\"name\": \"name\", \"type\": \"string\",\"confluent:tags\": [\"PII\"]},\n{\"name\": \"ssn\", \"type\": { \"type\": \"array\", \"items\": \"string\"},\"confluent:tags\": [\"PII\"]},\n{\"name\": \"piiArray\", \"type\": { \"type\": \"array\", \"items\": { \"type\": \"record\", \"name\":\"OldPii\", \"fields\":\n[{\"name\": \"pii\", \"type\": \"string\",\"confluent:tags\": [\"PII\"]}]}}},\n{\"name\": \"piiMap\", \"type\": { \"type\": \"map\", \"values\": \"OldPii\"},\n\"confluent:tags\": [\"PII\"]},\n{\"name\": \"size\", \"type\": \"int\"},{\"name\": \"version\", \"type\": \"int\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    @After
    public void tearDown() {
        MockSchemaRegistry.clear();
        MockDekRegistryClientFactory.clear();
    }

    @Test
    public void testKafkaAvroSerializer() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testKafkaAvroSerializerPreserveSource() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Assert.assertEquals((Object)"testUser", (Object)avroRecord.get("name"));
    }

    @Test
    public void testKafkaAvroDekRotation() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"1", (Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Dek dek = this.dekRegistry.getDekLatestVersion("kek1", this.topic + "-value", null, false);
        Assert.assertEquals((long)1L, (long)dek.getVersion());
        this.fakeClock.advance(2L, ChronoUnit.DAYS);
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        dek = this.dekRegistry.getDekLatestVersion("kek1", this.topic + "-value", null, false);
        Assert.assertEquals((long)2L, (long)dek.getVersion());
        this.fakeClock.advance(2L, ChronoUnit.DAYS);
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        dek = this.dekRegistry.getDekLatestVersion("kek1", this.topic + "-value", null, false);
        Assert.assertEquals((long)3L, (long)dek.getVersion());
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroDekRotationInvalidExpiry() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"-1", (Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
    }

    @Test
    public void testKafkaAvroSerializerWithAlgorithm() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"encrypt.dek.algorithm", (Object)"AES128_GCM"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, DekFormat.AES128_GCM);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, DekFormat.AES128_GCM);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testKafkaAvroSerializerBytes() throws Exception {
        IndexedRecord avroRecord = this.createUserBytesRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserBytesSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)ByteBuffer.wrap("testUser".getBytes(StandardCharsets.UTF_8)), (Object)record.get("name"));
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerInt() throws Exception {
        IndexedRecord avroRecord = this.createUserRecordWithTaggedInt();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchemaWithTaggedInt());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
    }

    @Test
    public void testKafkaAvroSerializerReflection() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 7;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.reflectionAvroSerializer);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Headers)headers, (Object)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.reflectionAvroDeserializer);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)"alice", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"123", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
    }

    @Test
    public void testKafkaAvroSerializerReflectionPreserveSource() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 7;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.reflectionAvroSerializer);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Headers)headers, (Object)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.reflectionAvroDeserializer);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)"alice", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"alice", (Object)widget.getName());
    }

    @Test
    public void testKafkaAvroSerializerMultipleRules() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        Rule rule2 = new Rule("rule2", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Assert.assertEquals((Object)"testUser2", (Object)record.get("name2"));
    }

    @Test
    public void testKafkaAvroSerializerMultipleRulesIncludingDekRotation() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        Rule rule2 = new Rule("rule2", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"1", (Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Assert.assertEquals((Object)"testUser2", (Object)record.get("name2"));
        this.fakeClock.advance(2L, ChronoUnit.DAYS);
        ++expectedEncryptions;
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Assert.assertEquals((Object)"testUser2", (Object)record.get("name2"));
        Dek dek = this.dekRegistry.getDekLatestVersion("kek1", this.topic + "-value", null, false);
        Assert.assertEquals((long)2L, (long)dek.getVersion());
    }

    @Test
    public void testKafkaAvroSerializerDoubleEncryption() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        Rule rule2 = new Rule("rule2", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII3")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testKafkaAvroSerializerDoubleEncryptionWithDekRotation() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        Rule rule2 = new Rule("rule2", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII3")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"1", (Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        this.fakeClock.advance(2L, ChronoUnit.DAYS);
        ++expectedEncryptions;
        headers = new RecordHeaders();
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Dek dek = this.dekRegistry.getDekLatestVersion("kek1", this.topic + "-value", null, false);
        Assert.assertEquals((long)2L, (long)dek.getVersion());
    }

    @Test
    public void testKafkaAvroSerializerDoubleEncryptionAllDekRotation() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"2", (Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        Rule rule2 = new Rule("rule2", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII3")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"1", (Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        this.fakeClock.advance(3L, ChronoUnit.DAYS);
        ++expectedEncryptions;
        headers = new RecordHeaders();
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptions * 2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
        Dek dek = this.dekRegistry.getDekLatestVersion("kek1", this.topic + "-value", null, false);
        Assert.assertEquals((long)3L, (long)dek.getVersion());
    }

    @Test
    public void testKafkaAvroSerializerRuleWithSameTag() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        Rule rule2 = new Rule("rule2", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptionsRule1 = 1;
        int expectedEncryptionsRule2 = 0;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule1");
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer, "rule2");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptionsRule1 + expectedEncryptionsRule2)))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptionsRule1))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptionsRule2))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule1");
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer, "rule2");
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        if (cryptor == cryptor2) {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)(expectedEncryptionsRule1 + expectedEncryptionsRule2)))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        } else {
            ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptionsRule1))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
            ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptionsRule2))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        }
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testKafkaAvroSerializerQualifiedRuleNames() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-key", (ParsedSchema)avroSchema);
        rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), null, null, null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroKeySerializer, "test-key:rule1");
        byte[] bytes = this.avroKeySerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Cryptor cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroValueSerializer, "test-value:rule1");
        RecordHeaders headers2 = new RecordHeaders();
        avroRecord = this.createUserRecord();
        byte[] bytes2 = this.avroValueSerializer.serialize(this.topic, (Headers)headers2, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroKeyDeserializer, "test-key:rule1");
        GenericRecord record = (GenericRecord)this.avroKeyDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        Assert.assertEquals((Object)"testUser2", (Object)record.get("name2").toString());
        cryptor2 = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroValueDeserializer, "test-value:rule1");
        GenericRecord record2 = (GenericRecord)this.avroValueDeserializer.deserialize(this.topic, (Headers)headers2, bytes2);
        ((Cryptor)Mockito.verify((Object)cryptor2, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record2.get("name").toString());
        Assert.assertEquals((Object)"testUser2", (Object)record2.get("name2").toString());
    }

    @Test
    public void testKafkaAvroSerializerExistingKek() throws Exception {
        this.dekRegistry.createKek("kek1", this.fieldEncryptionProps.getKmsType(), this.fieldEncryptionProps.getKmsKeyId(), this.fieldEncryptionProps.getKmsProps(), null, false);
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", "kek1");
        Metadata metadata = this.getMetadata(properties);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testKafkaAvroSerializerExistingSharedKek() throws Exception {
        this.dekRegistry.createKek("kek1", this.fieldEncryptionProps.getKmsType(), this.fieldEncryptionProps.getKmsKeyId(), this.fieldEncryptionProps.getKmsProps(), null, true);
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testKafkaAvroSerializerBadKekName() throws Exception {
        this.dekRegistry.createKek("kek1", this.fieldEncryptionProps.getKmsType(), this.fieldEncryptionProps.getKmsKeyId(), this.fieldEncryptionProps.getKmsProps(), null, false);
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", "$kek");
        properties.put("encrypt.kms.type", "wrong");
        Metadata metadata = this.getMetadata(properties);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        try {
            this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
    }

    @Test
    public void testKafkaAvroSerializerWrongKmsType() throws Exception {
        this.dekRegistry.createKek("kek1", this.fieldEncryptionProps.getKmsType(), this.fieldEncryptionProps.getKmsKeyId(), this.fieldEncryptionProps.getKmsProps(), null, false);
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", "kek1");
        properties.put("encrypt.kms.type", "wrong");
        Metadata metadata = this.getMetadata(properties);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        try {
            this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
    }

    @Test
    public void testKafkaAvroSerializerWrongKmsKeyId() throws Exception {
        this.dekRegistry.createKek("kek1", this.fieldEncryptionProps.getKmsType(), this.fieldEncryptionProps.getKmsKeyId(), this.fieldEncryptionProps.getKmsProps(), null, false);
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", "kek1");
        properties.put("encrypt.kms.key.id", "wrong");
        Metadata metadata = this.getMetadata(properties);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        try {
            this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
    }

    @Test
    public void testKafkaJsonSchemaSerializer() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = this.getMetadata("kek1");
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        int expectedEncryptions = 5;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.jsonSchemaSerializer);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Headers)headers, (Object)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.jsonSchemaDeserializer);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"123", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"456", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"789", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"012", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerPreserveSource() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"preserve.source.fields", (Object)"true"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = this.getMetadata("kek1");
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        int expectedEncryptions = 5;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.jsonSchemaSerializer);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Headers)headers, (Object)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.jsonSchemaDeserializer);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((Object)"alice", (Object)widget.getName());
    }

    @Test
    public void testKafkaJsonSchemaSerializerAnnotated() throws Exception {
        AnnotatedOldWidget widget = new AnnotatedOldWidget("alice");
        widget.setSize(123);
        widget.setAnnotatedSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<AnnotatedOldPii>)ImmutableList.of((Object)new AnnotatedOldPii("789"), (Object)new AnnotatedOldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = this.getMetadata("kek1");
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        int expectedEncryptions = 5;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.jsonSchemaSerializer2);
        byte[] bytes = this.jsonSchemaSerializer2.serialize(this.topic, (Headers)headers, (Object)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.jsonSchemaDeserializer);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"123", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"456", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"789", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"012", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaProtobufSerializer() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = this.getMetadata("kek1");
        protobufSchema = protobufSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        int expectedEncryptions = 7;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.protobufSerializer);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Headers)headers, (Message)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.protobufDeserializer);
        Message obj = this.protobufDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"alice", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)ImmutableList.of((Object)"123", (Object)"456"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return msg.getField(msg.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)ImmutableList.of((Object)"789", (Object)"012"), ssnArrayValues);
        List ssnMapValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_map"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            DynamicMessage msg2 = (DynamicMessage)msg.getField(msg.getDescriptorForType().findFieldByName("value"));
            return msg2.getField(msg2.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)ImmutableList.of((Object)"345", (Object)"678"), ssnMapValues);
    }

    @Test
    public void testKafkaProtobufSerializerBytes() throws Exception {
        WidgetBytesProto.WidgetBytes widget = WidgetBytesProto.WidgetBytes.newBuilder().setName(ByteString.copyFromUtf8((String)"alice")).addSsn(ByteString.copyFromUtf8((String)"123")).addSsn(ByteString.copyFromUtf8((String)"456")).addPiiArray(WidgetBytesProto.PiiBytes.newBuilder().setPii(ByteString.copyFromUtf8((String)"789")).build()).addPiiArray(WidgetBytesProto.PiiBytes.newBuilder().setPii(ByteString.copyFromUtf8((String)"012")).build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = this.getMetadata("kek1");
        protobufSchema = protobufSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        int expectedEncryptions = 5;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.protobufSerializerBytes);
        byte[] bytes = this.protobufSerializerBytes.serialize(this.topic, (Headers)headers, (Message)widget);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.protobufDeserializer);
        Message obj = this.protobufDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)ByteString.copyFromUtf8((String)"alice"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)ImmutableList.of((Object)ByteString.copyFromUtf8((String)"123"), (Object)ByteString.copyFromUtf8((String)"456")), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return (ByteString)msg.getField(msg.getDescriptorForType().findFieldByName("pii"));
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)ImmutableList.of((Object)ByteString.copyFromUtf8((String)"789"), (Object)ByteString.copyFromUtf8((String)"012")), ssnArrayValues);
    }

    @Test
    public void testNoEncryptionsDueToData() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"NOT_PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 0;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
    }

    @Test
    public void testBadCryptor() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        this.addBadSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        try {
            this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
        int expectedEncryptions = 1;
        headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        this.addBadSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        try {
            this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
    }

    @Test
    public void testBadCryptorIgnoreFailure() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addBadSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        headers = new RecordHeaders();
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addBadSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertNotEquals((Object)"testUser", (Object)record.get("name").toString());
    }

    @Test
    public void testBadSerializerWithMissingRuleExecutors() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        try {
            this.badSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
        int expectedEncryptions = 1;
        headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        try {
            this.badDeserializer.deserialize(this.topic, (Headers)headers, bytes);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
    }

    @Test
    public void testBadSerializerWithMissingRuleExecutorsButIgnoreFailure() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 0;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.badSerializer);
        Assert.assertNull((Object)cryptor);
        byte[] oldBytes = this.badSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        expectedEncryptions = 1;
        headers = new RecordHeaders();
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroSerializer);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertFalse((boolean)Arrays.equals(oldBytes, bytes));
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.badDeserializer);
        Assert.assertNull((Object)cryptor);
        GenericRecord record = (GenericRecord)this.badDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        Assert.assertNotEquals((Object)"testUser", (Object)record.get("name").toString());
    }

    @Test
    public void testGoodDekGenerator() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        int expectedEncryptions = 1;
        RecordHeaders headers = new RecordHeaders();
        Cryptor cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.goodDekSerializer);
        byte[] bytes = this.goodDekSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).encrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        cryptor = this.addSpyToCryptor((AbstractKafkaSchemaSerDe)this.avroDeserializer);
        GenericRecord record = (GenericRecord)this.avroDeserializer.deserialize(this.topic, (Headers)headers, bytes);
        ((Cryptor)Mockito.verify((Object)cryptor, (VerificationMode)Mockito.times((int)expectedEncryptions))).decrypt((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any());
        Assert.assertEquals((Object)"testUser", (Object)record.get("name"));
    }

    @Test
    public void testBadDekGenerator() throws Exception {
        GenericRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata("kek1");
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        RecordHeaders headers = new RecordHeaders();
        try {
            this.badDekSerializer.serialize(this.topic, (Headers)headers, (Object)avroRecord);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SerializationException));
        }
    }

    protected Metadata getMetadata(String kekName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", kekName);
        properties.put("encrypt.kms.type", this.fieldEncryptionProps.getKmsType());
        properties.put("encrypt.kms.key.id", this.fieldEncryptionProps.getKmsKeyId());
        return this.getMetadata(properties);
    }

    protected Metadata getMetadata(Map<String, String> properties) {
        return new Metadata(Collections.emptyMap(), properties, Collections.emptySet());
    }

    static {
        try {
            AeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class BadDekGenerator
    extends FieldEncryptionExecutor {
        protected byte[] generateDek(DekFormat dekFormat) throws GeneralSecurityException {
            return new byte[15];
        }
    }

    public static class GoodDekGenerator
    extends FieldEncryptionExecutor {
        protected byte[] generateDek(DekFormat dekFormat) throws GeneralSecurityException {
            return new byte[32];
        }
    }

    public static class AnnotatedOldPii {
        @JsonProperty(value="pii")
        private String annotatedPii;

        public AnnotatedOldPii() {
        }

        public AnnotatedOldPii(String annotatedPii) {
            this.annotatedPii = annotatedPii;
        }

        public String getAnnotatedPii() {
            return this.annotatedPii;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotatedOldPii pii1 = (AnnotatedOldPii)o;
            return Objects.equals(this.annotatedPii, pii1.annotatedPii);
        }

        public int hashCode() {
            return Objects.hash(this.annotatedPii);
        }
    }

    public static class AnnotatedOldWidget {
        private String annotatedName;
        private List<String> annotatedSsn = new ArrayList<String>();
        private List<AnnotatedOldPii> piiArray = new ArrayList<AnnotatedOldPii>();
        private Map<String, AnnotatedOldPii> piiMap = new HashMap<String, AnnotatedOldPii>();
        private int size;
        private int version;

        public AnnotatedOldWidget() {
        }

        public AnnotatedOldWidget(String annotatedName) {
            this.annotatedName = annotatedName;
        }

        @JsonProperty(value="name")
        public String getAnnotatedName() {
            return this.annotatedName;
        }

        @JsonProperty(value="name")
        public void setAnnotatedName(String name) {
            this.annotatedName = name;
        }

        @JsonProperty(value="ssn")
        public List<String> getAnnotatedSsn() {
            return this.annotatedSsn;
        }

        @JsonProperty(value="ssn")
        public void setAnnotatedSsn(List<String> ssn) {
            this.annotatedSsn = ssn;
        }

        public List<AnnotatedOldPii> getPiiArray() {
            return this.piiArray;
        }

        public void setPiiArray(List<AnnotatedOldPii> pii) {
            this.piiArray = pii;
        }

        public Map<String, AnnotatedOldPii> getPiiMap() {
            return this.piiMap;
        }

        public void setPiiMap(Map<String, AnnotatedOldPii> pii) {
            this.piiMap = pii;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldWidget widget = (OldWidget)o;
            return this.annotatedName.equals(widget.name) && Objects.equals(this.annotatedSsn, widget.ssn) && Objects.equals(this.piiArray, widget.piiArray) && Objects.equals(this.piiMap, widget.piiMap) && this.size == widget.size && this.version == widget.version;
        }

        public int hashCode() {
            return Objects.hash(this.annotatedName, this.annotatedSsn, this.piiArray, this.piiMap, this.size, this.version);
        }
    }

    public static class OldPii {
        private String pii;

        public OldPii() {
        }

        public OldPii(String pii) {
            this.pii = pii;
        }

        public String getPii() {
            return this.pii;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldPii pii1 = (OldPii)o;
            return Objects.equals(this.pii, pii1.pii);
        }

        public int hashCode() {
            return Objects.hash(this.pii);
        }
    }

    public static class OldWidget {
        private String name;
        private List<String> ssn = new ArrayList<String>();
        private List<OldPii> piiArray = new ArrayList<OldPii>();
        private Map<String, OldPii> piiMap = new HashMap<String, OldPii>();
        private int size;
        private int version;

        public OldWidget() {
        }

        public OldWidget(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getSsn() {
            return this.ssn;
        }

        public void setSsn(List<String> ssn) {
            this.ssn = ssn;
        }

        public List<OldPii> getPiiArray() {
            return this.piiArray;
        }

        public void setPiiArray(List<OldPii> pii) {
            this.piiArray = pii;
        }

        public Map<String, OldPii> getPiiMap() {
            return this.piiMap;
        }

        public void setPiiMap(Map<String, OldPii> pii) {
            this.piiMap = pii;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldWidget widget = (OldWidget)o;
            return this.name.equals(widget.name) && Objects.equals(this.ssn, widget.ssn) && Objects.equals(this.piiArray, widget.piiArray) && Objects.equals(this.piiMap, widget.piiMap) && this.size == widget.size && this.version == widget.version;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.ssn, this.piiArray, this.piiMap, this.size, this.version);
        }
    }
}

