/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.local;

import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalFieldEncryptionProperties
extends FieldEncryptionProperties {
    public LocalFieldEncryptionProperties(List<String> ruleNames) {
        super(ruleNames);
    }

    public LocalFieldEncryptionProperties(List<String> ruleNames, Class<?> ruleExecutor) {
        super(ruleNames, ruleExecutor);
    }

    @Override
    public String getKmsType() {
        return "local-kms";
    }

    @Override
    public String getKmsKeyId() {
        return "mykey";
    }

    @Override
    public Map<String, String> getKmsProps() {
        return Collections.singletonMap("secret", "mysecret");
    }

    @Override
    public Map<String, Object> getClientProperties(String baseUrls) {
        List<String> ruleNames = this.getRuleNames();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("schema.registry.url", baseUrls);
        props.put("auto.register.schemas", "false");
        props.put("use.latest.version", "true");
        props.put("latest.cache.ttl.sec", "60");
        props.put("rule.executors", String.join((CharSequence)",", ruleNames));
        for (String ruleName : ruleNames) {
            props.put("rule.executors." + ruleName + ".class", this.getRuleExecutor().getName());
            props.put("rule.executors." + ruleName + ".param." + "secret", "mysecret");
            props.put("rule.executors." + ruleName + ".param." + "old.secrets", "old1, old2");
        }
        return props;
    }

    @Override
    public Object getTestClient() throws Exception {
        return null;
    }
}

