/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.ConsumerAssignmentRequest;
import io.confluent.kafkarest.entities.ConsumerCommittedRequest;
import io.confluent.kafkarest.entities.ConsumerCommittedResponse;
import io.confluent.kafkarest.entities.ConsumerOffsetCommitRequest;
import io.confluent.kafkarest.entities.ConsumerSeekToOffsetRequest;
import io.confluent.kafkarest.entities.ConsumerSeekToRequest;
import io.confluent.kafkarest.entities.ConsumerSubscriptionRecord;
import io.confluent.kafkarest.entities.TopicPartition;
import io.confluent.kafkarest.entities.TopicPartitionOffset;
import io.confluent.kafkarest.entities.TopicPartitionOffsetMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import kafka.serializer.Decoder;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;

public abstract class KafkaConsumerState<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT>
implements Comparable<KafkaConsumerState> {
    private KafkaRestConfig config;
    private ConsumerInstanceId instanceId;
    private Consumer<KafkaKeyT, KafkaValueT> consumer;
    private ConsumerRecords<KafkaKeyT, KafkaValueT> consumerRecords = null;
    private List<ConsumerRecord<KafkaKeyT, KafkaValueT>> consumerRecordList = null;
    private int index = 0;
    private long expiration;
    private ReadWriteLock lock;

    public KafkaConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Consumer<KafkaKeyT, KafkaValueT> consumer) {
        this.config = config;
        this.instanceId = instanceId;
        this.consumer = consumer;
        this.expiration = config.getTime().milliseconds() + (long)config.getInt("consumer.instance.timeout.ms");
        this.lock = new ReentrantReadWriteLock();
    }

    public ConsumerInstanceId getId() {
        return this.instanceId;
    }

    protected abstract Decoder<KafkaKeyT> getKeyDecoder();

    protected abstract Decoder<KafkaValueT> getValueDecoder();

    public abstract ConsumerRecordAndSize<ClientKeyT, ClientValueT> createConsumerRecord(ConsumerRecord<KafkaKeyT, KafkaValueT> var1);

    public void startRead() {
        this.lock.readLock().lock();
    }

    public void finishRead() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicPartitionOffset> commitOffsets(String async, ConsumerOffsetCommitRequest offsetCommitRequest) {
        this.lock.writeLock().lock();
        try {
            if (offsetCommitRequest == null) {
                if (async == null) {
                    this.consumer.commitSync();
                } else {
                    this.consumer.commitAsync();
                }
            } else {
                HashMap<org.apache.kafka.common.TopicPartition, OffsetAndMetadata> offsetMap = new HashMap<org.apache.kafka.common.TopicPartition, OffsetAndMetadata>();
                for (TopicPartitionOffsetMetadata t : offsetCommitRequest.offsets) {
                    if (t.getMetadata() == null) {
                        offsetMap.put(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()), new OffsetAndMetadata(t.getOffset() + 1L));
                        continue;
                    }
                    offsetMap.put(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()), new OffsetAndMetadata(t.getOffset() + 1L, t.getMetadata()));
                }
                this.consumer.commitSync(offsetMap);
            }
            Vector result = new Vector();
            Vector vector = result;
            return vector;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToBeginning(ConsumerSeekToRequest seekToRequest) {
        this.lock.writeLock().lock();
        try {
            if (seekToRequest != null) {
                Vector<org.apache.kafka.common.TopicPartition> topicPartitions = new Vector<org.apache.kafka.common.TopicPartition>();
                for (TopicPartition t : seekToRequest.partitions) {
                    topicPartitions.add(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()));
                }
                this.consumer.seekToBeginning(topicPartitions);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToEnd(ConsumerSeekToRequest seekToRequest) {
        this.lock.writeLock().lock();
        try {
            if (seekToRequest != null) {
                Vector<org.apache.kafka.common.TopicPartition> topicPartitions = new Vector<org.apache.kafka.common.TopicPartition>();
                for (TopicPartition t : seekToRequest.partitions) {
                    topicPartitions.add(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()));
                }
                this.consumer.seekToEnd(topicPartitions);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToOffset(ConsumerSeekToOffsetRequest seekToOffsetRequest) {
        this.lock.writeLock().lock();
        try {
            if (seekToOffsetRequest != null) {
                Vector topicPartitions = new Vector();
                for (TopicPartitionOffsetMetadata t : seekToOffsetRequest.offsets) {
                    org.apache.kafka.common.TopicPartition topicPartition = new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition());
                    this.consumer.seek(topicPartition, t.getOffset());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(ConsumerAssignmentRequest assignmentRequest) {
        this.lock.writeLock().lock();
        try {
            if (assignmentRequest != null) {
                Vector<org.apache.kafka.common.TopicPartition> topicPartitions = new Vector<org.apache.kafka.common.TopicPartition>();
                for (TopicPartition t : assignmentRequest.partitions) {
                    topicPartitions.add(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()));
                }
                this.consumer.assign(topicPartitions);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void close() {
        this.lock.writeLock().lock();
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.consumer = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(ConsumerSubscriptionRecord subscription) {
        if (subscription == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.consumer != null) {
                if (subscription.topics != null) {
                    this.consumer.subscribe(subscription.topics);
                } else if (subscription.getTopicPattern() != null) {
                    Pattern topicPattern = Pattern.compile(subscription.getTopicPattern());
                    NoOpOnRebalance noOpOnRebalance = new NoOpOnRebalance();
                    this.consumer.subscribe(topicPattern, (ConsumerRebalanceListener)noOpOnRebalance);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unsubscribe() {
        this.lock.writeLock().lock();
        try {
            if (this.consumer != null) {
                this.consumer.unsubscribe();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<String> subscription() {
        Set currSubscription = null;
        this.lock.writeLock().lock();
        try {
            if (this.consumer != null) {
                currSubscription = this.consumer.subscription();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return currSubscription;
    }

    public Set<org.apache.kafka.common.TopicPartition> assignment() {
        Set currAssignment = null;
        this.lock.writeLock().lock();
        try {
            if (this.consumer != null) {
                currAssignment = this.consumer.assignment();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return currAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerCommittedResponse committed(ConsumerCommittedRequest request) {
        ConsumerCommittedResponse response = new ConsumerCommittedResponse();
        response.offsets = new Vector<TopicPartitionOffsetMetadata>();
        this.lock.writeLock().lock();
        try {
            if (this.consumer != null) {
                for (TopicPartition t : request.partitions) {
                    org.apache.kafka.common.TopicPartition partition = new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition());
                    OffsetAndMetadata offsetMetadata = this.consumer.committed(partition);
                    if (offsetMetadata == null) continue;
                    response.offsets.add(new TopicPartitionOffsetMetadata(partition.topic(), partition.partition(), offsetMetadata.offset(), offsetMetadata.metadata()));
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return response;
    }

    public boolean expired(long nowMs) {
        return this.expiration <= nowMs;
    }

    public void updateExpiration() {
        this.expiration = this.config.getTime().milliseconds() + (long)this.config.getInt("consumer.instance.timeout.ms");
    }

    public long untilExpiration(long nowMs) {
        return this.expiration - nowMs;
    }

    public KafkaRestConfig getConfig() {
        return this.config;
    }

    public void setConfig(KafkaRestConfig config) {
        this.config = config;
    }

    @Override
    public int compareTo(KafkaConsumerState o) {
        if (this.expiration < o.expiration) {
            return -1;
        }
        if (this.expiration == o.expiration) {
            return 0;
        }
        return 1;
    }

    void getOrCreateConsumerRecords() {
        this.index = 0;
        this.consumerRecordList = new ArrayList<ConsumerRecord<KafkaKeyT, KafkaValueT>>();
        this.consumerRecords = this.consumer.poll(100L);
        for (ConsumerRecord consumerRecord : this.consumerRecords) {
            this.consumerRecordList.add(consumerRecord);
        }
    }

    public ConsumerRecord<KafkaKeyT, KafkaValueT> peek() {
        if (this.hasNext()) {
            return this.consumerRecordList.get(this.index);
        }
        return null;
    }

    public boolean hasNext() {
        if (this.consumerRecordList != null && this.index < this.consumerRecordList.size()) {
            return true;
        }
        this.getOrCreateConsumerRecords();
        return this.consumerRecordList != null && this.index < this.consumerRecordList.size();
    }

    public ConsumerRecord<KafkaKeyT, KafkaValueT> next() {
        if (this.hasNext()) {
            ConsumerRecord<KafkaKeyT, KafkaValueT> record = this.consumerRecordList.get(this.index);
            ++this.index;
            return record;
        }
        return null;
    }

    private class NoOpOnRebalance
    implements ConsumerRebalanceListener {
        public void onPartitionsRevoked(Collection<org.apache.kafka.common.TopicPartition> partitions) {
        }

        public void onPartitionsAssigned(Collection<org.apache.kafka.common.TopicPartition> partitions) {
        }
    }
}

