/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.BinaryConsumerRecord;
import io.confluent.kafkarest.v2.KafkaConsumerState;
import kafka.serializer.Decoder;
import kafka.serializer.DefaultDecoder;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class BinaryKafkaConsumerState
extends KafkaConsumerState<byte[], byte[], byte[], byte[]> {
    private static final Decoder<byte[]> decoder = new DefaultDecoder(new VerifiableProperties());

    public BinaryKafkaConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Consumer consumer) {
        super(config, instanceId, consumer);
    }

    @Override
    protected Decoder<byte[]> getKeyDecoder() {
        return decoder;
    }

    @Override
    protected Decoder<byte[]> getValueDecoder() {
        return decoder;
    }

    @Override
    public ConsumerRecordAndSize<byte[], byte[]> createConsumerRecord(ConsumerRecord<byte[], byte[]> record) {
        long approxSize = (record.key() != null ? ((byte[])record.key()).length : 0) + (record.value() != null ? ((byte[])record.value()).length : 0);
        return new ConsumerRecordAndSize<byte[], byte[]>(new BinaryConsumerRecord((byte[])record.key(), (byte[])record.value(), record.topic(), record.partition(), record.offset()), approxSize);
    }
}

