/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.converters.AvroConverter;
import io.confluent.kafkarest.entities.AvroConsumerRecord;
import io.confluent.kafkarest.v2.KafkaConsumerState;
import java.util.Properties;
import kafka.serializer.Decoder;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class AvroKafkaConsumerState
extends KafkaConsumerState<Object, Object, JsonNode, JsonNode> {
    private Decoder<Object> decoder = null;

    public AvroKafkaConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Consumer consumer) {
        super(config, instanceId, consumer);
        Properties props = new Properties();
        props.setProperty("schema.registry.url", config.getString("schema.registry.url"));
    }

    @Override
    protected Decoder<Object> getKeyDecoder() {
        return this.decoder;
    }

    @Override
    protected Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public ConsumerRecordAndSize<JsonNode, JsonNode> createConsumerRecord(ConsumerRecord<Object, Object> record) {
        AvroConverter.JsonNodeAndSize keyNode = AvroConverter.toJson(record.key());
        AvroConverter.JsonNodeAndSize valueNode = AvroConverter.toJson(record.value());
        return new ConsumerRecordAndSize<JsonNode, JsonNode>(new AvroConsumerRecord(keyNode.json, valueNode.json, record.topic(), record.partition(), record.offset()), keyNode.size + valueNode.size);
    }
}

