/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.RecordMetadataOrException;
import io.confluent.kafkarest.entities.AvroProduceRecord;
import io.confluent.kafkarest.entities.BinaryProduceRecord;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.JsonProduceRecord;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionOffset;
import io.confluent.kafkarest.entities.PartitionProduceRequest;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceResponse;
import io.confluent.rest.annotations.PerformanceMetric;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/topics/{topic}/partitions")
@Produces(value={"application/vnd.kafka.binary.v2+json; qs=0.1", "application/vnd.kafka.avro.v2+json; qs=0.1", "application/vnd.kafka.v2+json; qs=0.9"})
@Consumes(value={"application/vnd.kafka.v2+json"})
public class PartitionsResource {
    private static final Logger log = LoggerFactory.getLogger(PartitionsResource.class);
    private final KafkaRestContext ctx;

    public PartitionsResource(KafkaRestContext ctx) {
        this.ctx = ctx;
    }

    @GET
    @PerformanceMetric(value="partitions.list+v2")
    public List<Partition> list(@Context HttpServletRequest httpRequest, final @PathParam(value="topic") String topic) throws Exception {
        return (List)this.runProxyQuery(new PrivilegedExceptionAction(){

            public List<Partition> run() throws Exception {
                PartitionsResource.this.checkTopicExists(topic);
                return PartitionsResource.this.ctx.getAdminClientWrapper().getTopicPartitions(topic);
            }
        }, httpRequest.getRemoteUser());
    }

    @GET
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.get+v2")
    public Partition getPartition(@Context HttpServletRequest httpRequest, final @PathParam(value="topic") String topic, final @PathParam(value="partition") int partition) throws Exception {
        return (Partition)this.runProxyQuery(new PrivilegedExceptionAction(){

            public Partition run() throws Exception {
                PartitionsResource.this.checkTopicExists(topic);
                Partition part = PartitionsResource.this.ctx.getAdminClientWrapper().getTopicPartition(topic, partition);
                if (part == null) {
                    throw Errors.partitionNotFoundException();
                }
                return part;
            }
        }, httpRequest.getRemoteUser());
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-binary+v2")
    @Consumes(value={"application/vnd.kafka.binary.v2+json"})
    public void produceBinary(final @Context HttpServletRequest httpRequest, final @Suspended AsyncResponse asyncResponse, final @PathParam(value="topic") String topic, final @PathParam(value="partition") int partition, final @Valid @NotNull PartitionProduceRequest<BinaryProduceRecord> request) throws Exception {
        this.runProxyQuery(new PrivilegedExceptionAction(){

            public Partition run() throws Exception {
                PartitionsResource.this.produce(httpRequest.getRemoteUser(), asyncResponse, topic, partition, EmbeddedFormat.BINARY, request);
                return null;
            }
        }, httpRequest.getRemoteUser());
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-json+v2")
    @Consumes(value={"application/vnd.kafka.json.v2+json"})
    public void produceJson(final @Context HttpServletRequest httpRequest, final @Suspended AsyncResponse asyncResponse, final @PathParam(value="topic") String topic, final @PathParam(value="partition") int partition, final @Valid @NotNull PartitionProduceRequest<JsonProduceRecord> request) throws Exception {
        this.runProxyQuery(new PrivilegedExceptionAction(){

            public Partition run() throws Exception {
                PartitionsResource.this.produce(httpRequest.getRemoteUser(), asyncResponse, topic, partition, EmbeddedFormat.JSON, request);
                return null;
            }
        }, httpRequest.getRemoteUser());
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-avro+v2")
    @Consumes(value={"application/vnd.kafka.avro.v2+json"})
    public void produceAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partition, @Valid @NotNull PartitionProduceRequest<AvroProduceRecord> request) {
        if (this.ctx.getConfig().isStreams()) {
            throw Errors.notSupportedByMapRStreams();
        }
        boolean hasKeys = false;
        boolean hasValues = false;
        for (AvroProduceRecord rec : request.getRecords()) {
            hasKeys = hasKeys || !rec.getJsonKey().isNull();
            hasValues = hasValues || !rec.getJsonValue().isNull();
        }
        if (hasKeys && request.getKeySchema() == null && request.getKeySchemaId() == null) {
            throw Errors.keySchemaMissingException();
        }
        if (hasValues && request.getValueSchema() == null && request.getValueSchemaId() == null) {
            throw Errors.valueSchemaMissingException();
        }
        this.produce(null, asyncResponse, topic, partition, EmbeddedFormat.AVRO, request);
    }

    protected <K, V, R extends ProduceRecord<K, V>> void produce(String userName, final AsyncResponse asyncResponse, String topic, int partition, EmbeddedFormat format, PartitionProduceRequest<R> request) {
        if (this.topicExists(topic) && !this.ctx.getAdminClientWrapper().partitionExists(topic, partition)) {
            throw Errors.partitionNotFoundException();
        }
        log.trace("Executing topic produce request id={} topic={} partition={} format={} request={}", new Object[]{asyncResponse, topic, partition, format, request});
        this.ctx.getProducerPool().produce(topic, partition, format, request, request.getRecords(), new ProducerPool.ProduceRequestCallback(){

            @Override
            public void onCompletion(Integer keySchemaId, Integer valueSchemaId, List<RecordMetadataOrException> results) {
                ProduceResponse response = new ProduceResponse();
                Vector<PartitionOffset> offsets = new Vector<PartitionOffset>();
                for (RecordMetadataOrException result : results) {
                    if (result.getException() != null) {
                        int errorCode = Errors.codeFromProducerException(result.getException());
                        String errorMessage = result.getException().getMessage();
                        offsets.add(new PartitionOffset(null, null, errorCode, errorMessage));
                        continue;
                    }
                    offsets.add(new PartitionOffset(result.getRecordMetadata().partition(), result.getRecordMetadata().offset(), null, null));
                }
                response.setOffsets(offsets);
                response.setKeySchemaId(keySchemaId);
                response.setValueSchemaId(valueSchemaId);
                log.trace("Completed topic produce request id={} response={}", (Object)asyncResponse, (Object)response);
                asyncResponse.resume((Object)response);
            }
        }, userName);
    }

    private boolean topicExists(String topic) {
        return this.ctx.getAdminClientWrapper().topicExists(topic);
    }

    private void checkTopicExists(String topic) {
        if (!this.topicExists(topic)) {
            throw Errors.topicNotFoundException();
        }
    }

    public Object runProxyQuery(PrivilegedExceptionAction action, String remoteUser) throws Exception {
        if (this.ctx.isImpersonationEnabled()) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)remoteUser, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            return ugi.doAs(action);
        }
        return action.run();
    }
}

