/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.KafkaStreamsMetadataObserver;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.RecordMetadataOrException;
import io.confluent.kafkarest.entities.AvroTopicProduceRecord;
import io.confluent.kafkarest.entities.BinaryTopicProduceRecord;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.JsonTopicProduceRecord;
import io.confluent.kafkarest.entities.PartitionOffset;
import io.confluent.kafkarest.entities.ProduceResponse;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.TopicProduceRecord;
import io.confluent.kafkarest.entities.TopicProduceRequest;
import io.confluent.rest.annotations.PerformanceMetric;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/topics")
@Produces(value={"application/vnd.kafka.v1+json; qs=0.9", "application/vnd.kafka+json; qs=0.8", "application/json; qs=0.5", "application/vnd.kafka.v2+json; qs=0.9"})
@Consumes(value={"application/vnd.kafka.v1+json", "application/vnd.kafka+json", "application/json", "application/octet-stream", "application/vnd.kafka.v2+json"})
public class TopicsResource {
    private static final Logger log = LoggerFactory.getLogger(TopicsResource.class);
    private final KafkaRestContext ctx;
    private final boolean isStreams;

    public TopicsResource(KafkaRestContext ctx) {
        this.ctx = ctx;
        this.isStreams = ctx.getConfig().isStreams();
    }

    @GET
    @PerformanceMetric(value="topics.list")
    public Collection<String> list(@Context HttpServletRequest httpRequest) throws Exception {
        return (Collection)this.runProxyQuery(new PrivilegedExceptionAction(){

            public Collection<String> run() throws Exception {
                final KafkaStreamsMetadataObserver metadataObserver = TopicsResource.this.ctx.getMetadataObserver();
                Collection<String> topics = metadataObserver.getTopicNames();
                if (TopicsResource.this.ctx.isImpersonationEnabled()) {
                    new Thread(){

                        @Override
                        public void run() {
                            metadataObserver.shutdown();
                        }
                    }.start();
                }
                return topics;
            }
        }, httpRequest.getRemoteUser());
    }

    @GET
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.get")
    public Topic getTopic(@Context HttpServletRequest httpRequest, final @PathParam(value="topic") String topicName) throws Exception {
        Topic topic = (Topic)this.runProxyQuery(new PrivilegedExceptionAction(){

            public Topic run() throws Exception {
                final KafkaStreamsMetadataObserver metadataObserver = TopicsResource.this.ctx.getMetadataObserver();
                Topic topic = metadataObserver.getTopic(topicName);
                if (TopicsResource.this.ctx.isImpersonationEnabled()) {
                    new Thread(){

                        @Override
                        public void run() {
                            metadataObserver.shutdown();
                        }
                    }.start();
                }
                return topic;
            }
        }, httpRequest.getRemoteUser());
        if (topic == null) {
            throw Errors.topicNotFoundException();
        }
        return topic;
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-binary")
    @Consumes(value={"application/vnd.kafka.binary.v1+json", "application/vnd.kafka.v1+json", "application/vnd.kafka+json", "application/json", "application/octet-stream", "application/vnd.kafka.binary.v2+json", "application/vnd.kafka.v2+json"})
    public void produceBinary(final @Context HttpServletRequest httpRequest, final @Suspended AsyncResponse asyncResponse, final @PathParam(value="topic") String topicName, final @Valid TopicProduceRequest<BinaryTopicProduceRecord> request) throws Exception {
        this.runProxyQuery(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TopicsResource.this.produce(httpRequest.getRemoteUser(), asyncResponse, topicName, EmbeddedFormat.BINARY, request);
                return null;
            }
        }, httpRequest.getRemoteUser());
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-json")
    @Consumes(value={"application/vnd.kafka.json.v1+json", "application/vnd.kafka.json.v2+json"})
    public void produceJson(final @Context HttpServletRequest httpRequest, final @Suspended AsyncResponse asyncResponse, final @PathParam(value="topic") String topicName, final @Valid TopicProduceRequest<JsonTopicProduceRecord> request) throws Exception {
        this.runProxyQuery(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TopicsResource.this.produce(httpRequest.getRemoteUser(), asyncResponse, topicName, EmbeddedFormat.JSON, request);
                return null;
            }
        }, httpRequest.getRemoteUser());
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-avro")
    @Consumes(value={"application/vnd.kafka.avro.v1+json", "application/vnd.kafka.avro.v2+json"})
    public void produceAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull TopicProduceRequest<AvroTopicProduceRecord> request) {
        if (this.isStreams) {
            throw Errors.notSupportedByMapRStreams();
        }
        boolean hasKeys = false;
        boolean hasValues = false;
        for (AvroTopicProduceRecord rec : request.getRecords()) {
            hasKeys = hasKeys || !rec.getJsonKey().isNull();
            hasValues = hasValues || !rec.getJsonValue().isNull();
        }
        if (hasKeys && request.getKeySchema() == null && request.getKeySchemaId() == null) {
            throw Errors.keySchemaMissingException();
        }
        if (hasValues && request.getValueSchema() == null && request.getValueSchemaId() == null) {
            throw Errors.valueSchemaMissingException();
        }
        this.produce(null, asyncResponse, topicName, EmbeddedFormat.AVRO, request);
    }

    public <K, V, R extends TopicProduceRecord<K, V>> void produce(String userName, final AsyncResponse asyncResponse, String topicName, EmbeddedFormat format, TopicProduceRequest<R> request) {
        log.trace("Executing topic produce request id={} topic={} format={} request={}", new Object[]{asyncResponse, topicName, format, request});
        if (!this.ctx.getConfig().isStreams() && !this.ctx.getMetadataObserver().topicExists(topicName)) {
            throw Errors.topicNotFoundException();
        }
        ProducerPool producerPool = this.ctx.getProducerPool();
        producerPool.produce(topicName, null, format, request, request.getRecords(), new ProducerPool.ProduceRequestCallback(){

            @Override
            public void onCompletion(Integer keySchemaId, Integer valueSchemaId, List<RecordMetadataOrException> results) {
                ProduceResponse response = new ProduceResponse();
                Vector<PartitionOffset> offsets = new Vector<PartitionOffset>();
                for (RecordMetadataOrException result : results) {
                    if (result.getException() != null) {
                        int errorCode = Errors.codeFromProducerException(result.getException());
                        String errorMessage = result.getException().getMessage();
                        offsets.add(new PartitionOffset(null, null, errorCode, errorMessage));
                        continue;
                    }
                    offsets.add(new PartitionOffset(result.getRecordMetadata().partition(), result.getRecordMetadata().offset(), null, null));
                }
                response.setOffsets(offsets);
                response.setKeySchemaId(keySchemaId);
                response.setValueSchemaId(valueSchemaId);
                log.trace("Completed topic produce request id={} response={}", (Object)asyncResponse, (Object)response);
                asyncResponse.resume((Object)response);
            }
        }, userName);
    }

    public Object runProxyQuery(PrivilegedExceptionAction action, String remoteUser) throws Exception {
        if (this.ctx.isImpersonationEnabled()) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)remoteUser, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            return ugi.doAs(action);
        }
        return action.run();
    }
}

