/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.rest.annotations.PerformanceMetric;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.hadoop.security.UserGroupInformation;

@Path(value="/streams")
@Produces(value={"application/vnd.kafka.binary.v1+json; qs=0.1", "application/vnd.kafka.avro.v1+json; qs=0.1", "application/vnd.kafka.json.v1+json; qs=0.1", "application/vnd.kafka.v1+json; qs=0.9", "application/vnd.kafka+json; qs=0.8", "application/json; qs=0.5"})
@Consumes
public class StreamsResource {
    private final KafkaRestContext ctx;

    public StreamsResource(KafkaRestContext ctx) {
        this.ctx = ctx;
    }

    @GET
    @Path(value="/{stream}/topics")
    @PerformanceMetric(value="stream.topics.list")
    public Collection<String> list(@Context HttpServletRequest httpRequest, final @PathParam(value="stream") String stream) throws Exception {
        return (Collection)this.runProxyQuery(new PrivilegedExceptionAction<Collection<String>>(){

            @Override
            public Collection<String> run() throws Exception {
                return StreamsResource.this.ctx.getMetadataObserver().getTopicNames(stream);
            }
        }, httpRequest.getRemoteUser());
    }

    public Object runProxyQuery(PrivilegedExceptionAction action, String remoteUser) throws Exception {
        if (this.ctx.isImpersonationEnabled()) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)remoteUser, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            return ugi.doAs(action);
        }
        return action.run();
    }
}

