/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.extension;

import io.confluent.kafkarest.AdminClientWrapper;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.KafkaStreamsMetadataObserver;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.SimpleConsumerFactory;
import io.confluent.kafkarest.SimpleConsumerManager;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.security.JaasUtils;
import org.eclipse.jetty.util.StringUtil;

public class KafkaRestContextProvider {
    private static KafkaRestContext defaultContext = null;
    private static ZkUtils defaultZkUtils = null;
    private static KafkaRestConfig defaultAppConfig = null;
    private static final InheritableThreadLocal<KafkaRestContext> restContextInheritableThreadLocal = new InheritableThreadLocal();
    private static AtomicBoolean initialized = new AtomicBoolean();

    public static void initialize(ZkUtils zkUtils, KafkaRestConfig appConfig, KafkaStreamsMetadataObserver mdObserver, ProducerPool producerPool, ConsumerManager consumerManager, SimpleConsumerFactory simpleConsumerFactory, SimpleConsumerManager simpleConsumerManager, KafkaConsumerManager kafkaConsumerManager, AdminClientWrapper adminClientWrapper) {
        if (initialized.compareAndSet(false, true) && !appConfig.isStreams()) {
            if (zkUtils == null && StringUtil.isNotBlank((String)appConfig.getString("zookeeper.connect"))) {
                zkUtils = ZkUtils.apply((String)appConfig.getString("zookeeper.connect"), (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled());
            }
            mdObserver = new KafkaStreamsMetadataObserver(appConfig, zkUtils, appConfig.isStreams(), appConfig.isImpersonationEnabled());
            if (consumerManager == null) {
                consumerManager = new ConsumerManager(appConfig, mdObserver);
            }
            if (simpleConsumerFactory == null) {
                simpleConsumerFactory = new SimpleConsumerFactory(appConfig);
            }
            if (simpleConsumerManager == null) {
                simpleConsumerManager = new SimpleConsumerManager(appConfig, mdObserver, simpleConsumerFactory);
            }
            defaultZkUtils = zkUtils;
            defaultContext = new DefaultKafkaRestContext(appConfig, mdObserver, producerPool, consumerManager, simpleConsumerManager, kafkaConsumerManager, adminClientWrapper, zkUtils, appConfig.isStreams(), appConfig.isImpersonationEnabled());
            defaultAppConfig = appConfig;
        }
    }

    public KafkaRestConfig getConfig() {
        return defaultAppConfig;
    }

    public static ZkUtils getDefaultZkUtils() {
        return defaultZkUtils;
    }

    public static KafkaRestConfig getDefaultAppConfig() {
        return defaultAppConfig;
    }

    public static KafkaRestContext getDefaultContext() {
        return defaultContext;
    }

    public static KafkaRestContext getCurrentContext() {
        if (restContextInheritableThreadLocal.get() != null) {
            return (KafkaRestContext)restContextInheritableThreadLocal.get();
        }
        return defaultContext;
    }

    public static void setCurrentContext(KafkaRestContext kafkaRestContext) {
        restContextInheritableThreadLocal.set(kafkaRestContext);
    }

    public static void clearCurrentContext() {
        restContextInheritableThreadLocal.remove();
    }

    public static synchronized void clean() {
        defaultContext.shutdown();
        defaultContext = null;
        if (defaultZkUtils != null) {
            defaultZkUtils.close();
        }
        initialized.set(false);
    }
}

