/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public class TopicPartitionOffset {
    @NotEmpty
    private String topic;
    @Min(value=0L)
    private int partition;
    @Min(value=0L)
    private long consumed;
    @Min(value=0L)
    private long committed;

    public TopicPartitionOffset(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="consumed") long consumed, @JsonProperty(value="committed") long committed) {
        this.topic = topic;
        this.partition = partition;
        this.consumed = consumed;
        this.committed = committed;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public void setPartition(int partition) {
        this.partition = partition;
    }

    @JsonProperty
    public long getConsumed() {
        return this.consumed;
    }

    @JsonProperty
    public void setConsumed(long consumed) {
        this.consumed = consumed;
    }

    @JsonProperty
    public long getCommitted() {
        return this.committed;
    }

    @JsonProperty
    public void setCommitted(long committed) {
        this.committed = committed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionOffset that = (TopicPartitionOffset)o;
        if (this.committed != that.committed) {
            return false;
        }
        if (this.consumed != that.consumed) {
            return false;
        }
        if (this.partition != that.partition) {
            return false;
        }
        return !(this.topic != null ? !this.topic.equals(that.topic) : that.topic != null);
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + this.partition;
        result = 31 * result + (int)(this.consumed ^ this.consumed >>> 32);
        result = 31 * result + (int)(this.committed ^ this.committed >>> 32);
        return result;
    }
}

