/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Min;

public class PartitionReplica {
    @Min(value=0L)
    private int broker;
    private boolean leader;
    private boolean inSync;

    public PartitionReplica() {
    }

    public PartitionReplica(int broker, boolean leader, boolean inSync) {
        this.broker = broker;
        this.leader = leader;
        this.inSync = inSync;
    }

    @JsonProperty
    public int getBroker() {
        return this.broker;
    }

    @JsonProperty
    public void setBroker(int broker) {
        this.broker = broker;
    }

    @JsonProperty
    public boolean isLeader() {
        return this.leader;
    }

    @JsonProperty
    public void setLeader(boolean leader) {
        this.leader = leader;
    }

    @JsonProperty(value="in_sync")
    public boolean isInSync() {
        return this.inSync;
    }

    @JsonProperty(value="in_sync")
    public void setInSync(boolean inSync) {
        this.inSync = inSync;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionReplica)) {
            return false;
        }
        PartitionReplica that = (PartitionReplica)o;
        if (this.broker != that.broker) {
            return false;
        }
        if (this.inSync != that.inSync) {
            return false;
        }
        return this.leader == that.leader;
    }

    public int hashCode() {
        int result = this.broker;
        result = 31 * result + (this.leader ? 1 : 0);
        result = 31 * result + (this.inSync ? 1 : 0);
        return result;
    }

    public String toString() {
        return "PartitionReplica{broker=" + this.broker + ", leader=" + this.leader + ", inSync=" + this.inSync + '}';
    }
}

