/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.confluent.kafkarest.AvroConsumerState;
import io.confluent.kafkarest.BinaryConsumerState;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.JsonConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.rest.exceptions.RestServerErrorException;
import java.util.Properties;
import javax.ws.rs.core.Response;

@JsonFormat(shape=JsonFormat.Shape.STRING)
public enum EmbeddedFormat {
    BINARY,
    AVRO,
    JSON;


    public static ConsumerState createConsumerState(EmbeddedFormat embeddedFormat, KafkaRestConfig config, ConsumerInstanceId consumerInstanceIdId, Properties consumerProperties, ConsumerManager.ConsumerFactory consumerFactory) {
        switch (embeddedFormat) {
            case BINARY: {
                return new BinaryConsumerState(config, consumerInstanceIdId, consumerProperties, consumerFactory);
            }
            case AVRO: {
                return new AvroConsumerState(config, consumerInstanceIdId, consumerProperties, consumerFactory);
            }
            case JSON: {
                return new JsonConsumerState(config, consumerInstanceIdId, consumerProperties, consumerFactory);
            }
        }
        throw new RestServerErrorException("Invalid embedded format for new consumer.", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }
}

