/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.AbstractConsumerRecord;
import io.confluent.kafkarest.entities.EntityUtils;
import io.confluent.rest.validation.ConstraintViolations;
import java.io.IOException;
import java.util.Arrays;

public class BinaryConsumerRecord
extends AbstractConsumerRecord<byte[], byte[]> {
    public BinaryConsumerRecord(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="offset") long offset) throws IOException {
        super(topic, partition, offset);
        try {
            if (key != null) {
                this.key = EntityUtils.parseBase64Binary(key);
            }
        }
        catch (IllegalArgumentException e) {
            throw ConstraintViolations.simpleException((String)"Record key contains invalid base64 encoding");
        }
        try {
            this.value = EntityUtils.parseBase64Binary(value);
        }
        catch (IllegalArgumentException e) {
            throw ConstraintViolations.simpleException((String)"Record value contains invalid base64 encoding");
        }
    }

    public BinaryConsumerRecord(byte[] key, byte[] value, String topic, int partition, long offset) {
        super(key, value, topic, partition, offset);
    }

    @Override
    @JsonProperty(value="key")
    public String getJsonKey() {
        if (this.key == null) {
            return null;
        }
        return EntityUtils.encodeBase64Binary((byte[])this.key);
    }

    @Override
    @JsonProperty(value="value")
    public String getJsonValue() {
        if (this.value == null) {
            return null;
        }
        return EntityUtils.encodeBase64Binary((byte[])this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryConsumerRecord that = (BinaryConsumerRecord)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.partition != that.partition) {
            return false;
        }
        if (!Arrays.equals((byte[])this.key, (byte[])that.key)) {
            return false;
        }
        return Arrays.equals((byte[])this.value, (byte[])that.value);
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? Arrays.hashCode((byte[])this.key) : 0;
        result = 31 * result + (this.value != null ? Arrays.hashCode((byte[])this.value) : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + this.partition;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }
}

