/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public abstract class AbstractConsumerRecord<K, V> {
    protected K key;
    @NotNull
    protected V value;
    @NotNull
    protected String topic;
    @Min(value=0L)
    protected int partition;
    @Min(value=0L)
    protected long offset;

    public AbstractConsumerRecord(K key, V value, String topic, int partition, long offset) {
        this.key = key;
        this.value = value;
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
    }

    public AbstractConsumerRecord(K key, V value, int partition, long offset) {
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.offset = offset;
    }

    public AbstractConsumerRecord(String topic, int partition, long offset) {
        this(null, null, topic, partition, offset);
    }

    public AbstractConsumerRecord(int partition, long offset) {
        this(null, null, partition, offset);
    }

    @JsonIgnore
    public K getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public Object getJsonKey() {
        return this.key;
    }

    @JsonIgnore
    public void setKey(K key) {
        this.key = key;
    }

    @JsonIgnore
    public V getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public Object getJsonValue() {
        return this.value;
    }

    @JsonIgnore
    public void setValue(V value) {
        this.value = value;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public void setPartition(int partition) {
        this.partition = partition;
    }

    @JsonProperty
    public long getOffset() {
        return this.offset;
    }

    @JsonProperty
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConsumerRecord that = (AbstractConsumerRecord)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.partition != that.partition) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + this.partition;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }
}

