/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.Errors;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamsMetadataConsumer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamsMetadataConsumer.class);
    private KafkaConsumer<byte[], byte[]> metadataConsumer;
    private Lock consumerLock;

    StreamsMetadataConsumer(String bootstrapServers, String defaultStream) {
        Properties properties = new Properties();
        if (bootstrapServers != null) {
            properties.setProperty("bootstrap.servers", bootstrapServers);
        }
        boolean defaultStreamProvided = false;
        if (!"".equals(defaultStream)) {
            properties.setProperty("streams.consumer.default.stream", defaultStream);
            defaultStreamProvided = true;
        }
        this.metadataConsumer = new KafkaConsumer(properties, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        if (!defaultStreamProvided) {
            try {
                Method method = this.metadataConsumer.getClass().getDeclaredMethod("initializeConsumer", String.class);
                method.setAccessible(true);
                method.invoke(this.metadataConsumer, "/:");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Metadata consumer error: ", (Throwable)e);
            }
        }
        this.consumerLock = new ReentrantLock(true);
    }

    Map<String, List<PartitionInfo>> listTopics(String stream) {
        this.consumerLock.lock();
        try {
            Map map = this.metadataConsumer.listTopics(stream);
            return map;
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    Map<String, List<PartitionInfo>> listTopics() {
        this.consumerLock.lock();
        try {
            Map map = this.metadataConsumer.listTopics();
            return map;
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    List<PartitionInfo> partitionsFor(String topic) {
        this.consumerLock.lock();
        try {
            List list = this.metadataConsumer.partitionsFor(topic);
            return list;
        }
        catch (UnknownTopicOrPartitionException e) {
            throw Errors.topicNotFoundException();
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
        this.metadataConsumer.wakeup();
        this.consumerLock.lock();
        try {
            this.metadataConsumer.close();
        }
        finally {
            this.consumerLock.unlock();
        }
    }
}

