/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.SimpleConsumerConfig;
import io.confluent.kafkarest.SimpleConsumerManager;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConsumerFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleConsumerManager.class);
    private final KafkaRestConfig config;
    private final SimpleConsumerConfig simpleConsumerConfig;
    private final AtomicInteger clientIdCounter;

    public SimpleConsumerFactory(KafkaRestConfig config) {
        this.config = config;
        this.clientIdCounter = new AtomicInteger(0);
        this.simpleConsumerConfig = new SimpleConsumerConfig(config.getOriginalProperties());
    }

    public SimpleConsumerConfig getSimpleConsumerConfig() {
        return this.simpleConsumerConfig;
    }

    private String nextClientId() {
        StringBuilder id = new StringBuilder();
        id.append("rest-simpleconsumer-");
        String serverId = this.config.getString("id");
        if (!serverId.isEmpty()) {
            id.append(serverId);
            id.append("-");
        }
        id.append(Integer.toString(this.clientIdCounter.incrementAndGet()));
        return id.toString();
    }

    public ConsumerProvider createConsumer() {
        String clientId = this.nextClientId();
        log.debug("Creating SimpleConsumer with id " + clientId);
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", this.config.getString("bootstrap.servers"));
        properties.setProperty("client.id", clientId);
        String defaultStream = this.config.getString("streams.default.stream");
        if (!"".equals(defaultStream)) {
            properties.setProperty("streams.consumer.default.stream", defaultStream);
        }
        KafkaConsumer consumer = new KafkaConsumer(properties, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        return new ConsumerProvider((Consumer<byte[], byte[]>)consumer, clientId);
    }

    public static class ConsumerProvider {
        private Consumer<byte[], byte[]> consumer;
        private String clientId;

        public ConsumerProvider(Consumer<byte[], byte[]> consumer, String clientId) {
            this.consumer = consumer;
            this.clientId = clientId;
        }

        public Consumer<byte[], byte[]> consumer() {
            return this.consumer;
        }

        public String clientId() {
            return this.clientId;
        }
    }
}

