/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.ProduceTask;
import io.confluent.kafkarest.RestProducer;
import io.confluent.kafkarest.entities.ProduceRecord;
import java.util.Collection;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class NoSchemaRestProducer<K, V>
implements RestProducer<K, V> {
    private KafkaProducer<K, V> producer;

    public NoSchemaRestProducer(KafkaProducer<K, V> producer) {
        this.producer = producer;
    }

    @Override
    public void produce(ProduceTask task, String topic, Integer partition, Collection<? extends ProduceRecord<K, V>> produceRecords) {
        for (ProduceRecord<K, V> record : produceRecords) {
            Integer recordPartition = partition;
            if (recordPartition == null) {
                recordPartition = record.partition();
            }
            this.producer.send(new ProducerRecord(topic, recordPartition, record.getKey(), record.getValue()), task.createCallback());
        }
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

