/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.rest.exceptions.RestNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.ws.rs.InternalServerErrorException;
import kafka.admin.AdminUtils;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.utils.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;

@Deprecated
public class MetadataObserver {
    private static final Logger log = LoggerFactory.getLogger(MetadataObserver.class);
    private ZkUtils zkUtils;

    public MetadataObserver(ZkUtils zkUtils) {
        this.zkUtils = zkUtils;
    }

    public Broker getLeader(String topicName, int partitionId) {
        return this.getBrokerById(this.getLeaderId(topicName, partitionId));
    }

    public List<Topic> getTopics() {
        try {
            Seq topicNames = (Seq)this.zkUtils.getAllTopics().sorted((Ordering)Ordering.String$.MODULE$);
            return this.getTopicsData((Seq<String>)topicNames);
        }
        catch (RestNotFoundException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public boolean topicExists(String topicName) {
        Collection<String> topicNames = this.getTopicNames();
        for (String topic : topicNames) {
            if (!topic.equals(topicName)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getTopicNames() {
        Seq topicNames = (Seq)this.zkUtils.getAllTopics().sorted((Ordering)Ordering.String$.MODULE$);
        return JavaConversions.asJavaCollection((Iterable)topicNames);
    }

    public int getLeaderId(String topicName, int partitionId) {
        List<Partition> partitions = this.getTopicPartitions(topicName);
        if (partitions.size() == 0) {
            throw Errors.topicNotFoundException();
        }
        for (Partition partition : partitions) {
            if (partition.getPartition() != partitionId) continue;
            return partition.getLeader();
        }
        throw Errors.partitionNotFoundException();
    }

    public Broker getBrokerById(int brokerId) {
        Option broker = this.zkUtils.getBrokerInfo(brokerId);
        if (broker.isDefined()) {
            return (Broker)broker.get();
        }
        throw Errors.leaderNotAvailableException();
    }

    public List<Topic> getTopicsData(Seq<String> topicNames) {
        scala.collection.mutable.Map topicPartitions = this.zkUtils.getPartitionAssignmentForTopics(topicNames);
        Vector<Topic> topics = new Vector<Topic>(topicNames.size());
        Map configs = AdminUtils.fetchAllTopicConfigs((ZkUtils)this.zkUtils);
        for (String topicName : JavaConversions.asJavaCollection(topicNames)) {
            Map partitionMap;
            List<Partition> partitions;
            if (topicPartitions.get((Object)topicName).isEmpty() || (partitions = this.extractPartitionsFromZkData((Map<Object, Seq<Object>>)(partitionMap = (Map)topicPartitions.get((Object)topicName).get()), topicName, null)).size() == 0) continue;
            Option topicConfigOpt = configs.get((Object)topicName);
            Properties topicConfigs = topicConfigOpt.isEmpty() ? new Properties() : (Properties)topicConfigOpt.get();
            Topic topic = new Topic(topicName, topicConfigs, partitions);
            topics.add(topic);
        }
        return topics;
    }

    public List<Partition> getTopicPartitions(String topic) {
        return this.getTopicPartitions(topic, null);
    }

    public List<Partition> getTopicPartitions(String topic, Integer partitionsFilter) {
        scala.collection.mutable.Map topicPartitions = this.zkUtils.getPartitionAssignmentForTopics((Seq)JavaConversions.asScalaBuffer(Arrays.asList(topic)));
        if (!topicPartitions.get((Object)topic).isEmpty()) {
            Map parts = (Map)topicPartitions.get((Object)topic).get();
            return this.extractPartitionsFromZkData((Map<Object, Seq<Object>>)parts, topic, partitionsFilter);
        }
        return null;
    }

    public List<Partition> extractPartitionsFromZkData(Map<Object, Seq<Object>> parts, String topic, Integer partitionsFilter) {
        Vector<Partition> partitions = new Vector<Partition>();
        java.util.Map partsJava = JavaConversions.mapAsJavaMap(parts);
        for (Map.Entry part : partsJava.entrySet()) {
            int partId = (Integer)part.getKey();
            if (partitionsFilter != null && partitionsFilter != partId) continue;
            Partition p = new Partition();
            p.setPartition(partId);
            Option leaderAndIsrOpt = this.zkUtils.getLeaderAndIsrForPartition(topic, partId);
            if (leaderAndIsrOpt.isEmpty()) continue;
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)leaderAndIsrOpt.get();
            p.setLeader(leaderAndIsr.leader());
            Set isr = leaderAndIsr.isr().toSet();
            Vector<PartitionReplica> partReplicas = new Vector<PartitionReplica>();
            for (Object brokerObj : JavaConversions.asJavaCollection((Iterable)((Iterable)part.getValue()))) {
                int broker = (Integer)brokerObj;
                PartitionReplica r = new PartitionReplica(broker, leaderAndIsr.leader() == broker, isr.contains((Object)broker));
                partReplicas.add(r);
            }
            p.setReplicas(partReplicas);
            partitions.add(p);
        }
        return partitions;
    }

    public void shutdown() {
        log.debug("Shutting down MetadataObserver");
    }
}

