/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.AdminClientWrapper;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.KafkaStreamsMetadataObserver;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.SimpleConsumerFactory;
import io.confluent.kafkarest.SimpleConsumerManager;
import io.confluent.kafkarest.extension.KafkaRestCleanupFilter;
import io.confluent.kafkarest.extension.RestResourceExtension;
import io.confluent.kafkarest.resources.BrokersResource;
import io.confluent.kafkarest.resources.RootResource;
import io.confluent.kafkarest.resources.TopicsResource;
import io.confluent.kafkarest.resources.v2.ConsumersResource;
import io.confluent.kafkarest.resources.v2.PartitionsResource;
import io.confluent.kafkarest.resources.v2.StreamsResource;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.security.JaasUtils;
import org.eclipse.jetty.util.StringUtil;

public class KafkaRestApplication
extends Application<KafkaRestConfig> {
    RestResourceExtension restResourceExtension;
    boolean isStreams;
    KafkaRestContext context;

    public KafkaRestApplication() throws RestConfigException {
        this(new Properties());
    }

    public KafkaRestApplication(Properties props) throws RestConfigException {
        super((RestConfig)new KafkaRestConfig(props));
    }

    public KafkaRestApplication(KafkaRestConfig config) throws IllegalAccessException, InstantiationException, RestConfigException {
        super((RestConfig)config);
        String extensionClassName = config.getString("kafka.rest.resource.extension.class");
        if (StringUtil.isNotBlank((String)extensionClassName)) {
            try {
                Class<?> restResourceExtensionClass = Class.forName(extensionClassName);
                this.restResourceExtension = (RestResourceExtension)restResourceExtensionClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RestConfigException("Unable to load resource extension class " + extensionClassName + ". Check your classpath and that the configured class implements " + "the RestResourceExtension interface.");
            }
        }
    }

    public void setupResources(Configurable<?> config, KafkaRestConfig appConfig) {
        this.setupInjectedResources(config, appConfig, null, null, null, null, null, null, null, null);
    }

    protected void setupInjectedResources(Configurable<?> config, KafkaRestConfig appConfig, ZkUtils zkUtils, KafkaStreamsMetadataObserver mdObserver, ProducerPool producerPool, ConsumerManager consumerManager, SimpleConsumerFactory simpleConsumerFactory, SimpleConsumerManager simpleConsumerManager, KafkaConsumerManager kafkaConsumerManager, AdminClientWrapper adminClientWrapperInjected) {
        this.isStreams = appConfig.isStreams();
        if (appConfig.isImpersonationEnabled() && !appConfig.getString("authentication.realm").equals("jpamLogin")) {
            throw new RuntimeException("PAM Authentication must be enabled in order to support MapR Streams impersonation");
        }
        if (!this.isStreams && zkUtils == null && StringUtil.isNotBlank((String)appConfig.getString("zookeeper.connect"))) {
            zkUtils = ZkUtils.apply((String)appConfig.getString("zookeeper.connect"), (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled());
        }
        mdObserver = new KafkaStreamsMetadataObserver(appConfig, zkUtils, appConfig.isStreams(), appConfig.isImpersonationEnabled());
        if (producerPool == null) {
            producerPool = new ProducerPool(appConfig, null);
        }
        if (consumerManager == null) {
            consumerManager = new ConsumerManager(appConfig, mdObserver);
        }
        if (simpleConsumerFactory == null) {
            simpleConsumerFactory = new SimpleConsumerFactory(appConfig);
        }
        if (simpleConsumerManager == null) {
            simpleConsumerManager = new SimpleConsumerManager(appConfig, mdObserver, simpleConsumerFactory);
        }
        this.context = new DefaultKafkaRestContext(appConfig, mdObserver, producerPool, consumerManager, simpleConsumerManager, kafkaConsumerManager, adminClientWrapperInjected, zkUtils, appConfig.isStreams(), appConfig.isImpersonationEnabled());
        config.register(RootResource.class);
        config.register((Object)new BrokersResource(this.context));
        config.register((Object)new TopicsResource(this.context));
        config.register((Object)new io.confluent.kafkarest.resources.PartitionsResource(this.context));
        config.register((Object)new io.confluent.kafkarest.resources.ConsumersResource(this.context));
        config.register((Object)new io.confluent.kafkarest.resources.StreamsResource(this.context));
        config.register((Object)new StreamsResource(this.context));
        config.register((Object)new ConsumersResource(this.context));
        config.register((Object)new PartitionsResource(this.context));
        config.register(KafkaRestCleanupFilter.class);
        if (this.restResourceExtension != null) {
            this.restResourceExtension.register(config, appConfig);
        }
    }

    public void onShutdown() {
        if (this.restResourceExtension != null) {
            this.restResourceExtension.clean();
        }
        this.context.getConsumerManager().shutdown();
        this.context.getProducerPool().shutdown();
        this.context.getSimpleConsumerManager().shutdown();
        this.context.getMetadataObserver().shutdown();
    }
}

