/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.JsonConsumerRecord;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonConsumerState
extends ConsumerState<byte[], byte[], Object, Object> {
    private static final Deserializer<byte[]> deserializer = new ByteArrayDeserializer();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public JsonConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Properties consumerProperties, ConsumerManager.ConsumerFactory consumerFactory) {
        super(config, instanceId, consumerProperties, consumerFactory);
    }

    @Override
    protected Deserializer<byte[]> getKeyDeserializer() {
        return deserializer;
    }

    @Override
    protected Deserializer<byte[]> getValueDeserializer() {
        return deserializer;
    }

    @Override
    public ConsumerRecordAndSize<Object, Object> convertConsumerRecord(ConsumerRecord<byte[], byte[]> msg) {
        long approxSize = 0L;
        Object key = null;
        Object value = null;
        if (msg.key() != null) {
            approxSize += (long)((byte[])msg.key()).length;
            key = this.deserialize((byte[])msg.key());
        }
        if (msg.value() != null) {
            approxSize += (long)((byte[])msg.value()).length;
            value = this.deserialize((byte[])msg.value());
        }
        return new ConsumerRecordAndSize<Object, Object>(new JsonConsumerRecord(key, value, msg.topic(), msg.partition(), msg.offset()), approxSize);
    }

    private Object deserialize(byte[] data) {
        try {
            return objectMapper.readValue(data, Object.class);
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

