/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.AdminClientWrapper;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.KafkaStreamsMetadataObserver;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.SimpleConsumerFactory;
import io.confluent.kafkarest.SimpleConsumerManager;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import kafka.utils.ZkUtils;

public class DefaultKafkaRestContext
implements KafkaRestContext {
    private final KafkaRestConfig config;
    private final KafkaStreamsMetadataObserver metadataObserver;
    private ProducerPool producerPool;
    private final ConsumerManager consumerManager;
    private KafkaConsumerManager kafkaConsumerManager;
    private final SimpleConsumerManager simpleConsumerManager;
    private AdminClientWrapper adminClientWrapper;
    private final ZkUtils zkUtils;
    private final boolean isStreams;
    private final boolean isImpersonationEnabled;

    public DefaultKafkaRestContext(KafkaRestConfig config, KafkaStreamsMetadataObserver metadataObserver, ProducerPool producerPool, ConsumerManager consumerManager, SimpleConsumerManager simpleConsumerManager, KafkaConsumerManager kafkaConsumerManager, AdminClientWrapper adminClientWrapper, ZkUtils zkUtils, boolean isStreams, boolean isImpersonationEnabled) {
        this.config = config;
        this.metadataObserver = metadataObserver;
        this.producerPool = producerPool;
        this.consumerManager = consumerManager;
        this.simpleConsumerManager = simpleConsumerManager;
        this.kafkaConsumerManager = kafkaConsumerManager;
        this.adminClientWrapper = adminClientWrapper;
        this.zkUtils = zkUtils;
        this.isStreams = isStreams;
        this.isImpersonationEnabled = isImpersonationEnabled;
    }

    @Override
    public KafkaRestConfig getConfig() {
        return this.config;
    }

    @Override
    public KafkaStreamsMetadataObserver getMetadataObserver() {
        if (this.isImpersonationEnabled) {
            return new KafkaStreamsMetadataObserver(this.config, this.zkUtils, this.isStreams, this.isImpersonationEnabled);
        }
        return this.metadataObserver;
    }

    @Override
    public ProducerPool getProducerPool() {
        return this.producerPool;
    }

    @Override
    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    @Override
    public SimpleConsumerManager getSimpleConsumerManager() {
        if (this.isImpersonationEnabled) {
            return new SimpleConsumerManager(this.config, this.getMetadataObserver(), new SimpleConsumerFactory(this.config));
        }
        return this.simpleConsumerManager;
    }

    @Override
    public KafkaConsumerManager getKafkaConsumerManager() {
        if (this.kafkaConsumerManager == null) {
            this.kafkaConsumerManager = new KafkaConsumerManager(this.config);
        }
        return this.kafkaConsumerManager;
    }

    @Override
    public AdminClientWrapper getAdminClientWrapper() {
        if (this.adminClientWrapper == null) {
            this.adminClientWrapper = new AdminClientWrapper(this.config);
        }
        return this.adminClientWrapper;
    }

    public ZkUtils getZkUtils() {
        return this.zkUtils;
    }

    public boolean isStreams() {
        return this.isStreams;
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.isImpersonationEnabled;
    }

    @Override
    public void shutdown() {
        if (this.kafkaConsumerManager != null) {
            this.kafkaConsumerManager.shutdown();
        }
        if (this.producerPool != null) {
            this.producerPool.shutdown();
        }
        if (this.simpleConsumerManager != null) {
            this.simpleConsumerManager.shutdown();
        }
        if (this.consumerManager != null) {
            this.consumerManager.shutdown();
        }
        if (this.adminClientWrapper != null) {
            this.adminClientWrapper.shutdown();
        }
        if (this.metadataObserver != null) {
            this.metadataObserver.shutdown();
        }
    }
}

