/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.ConsumerReadTask;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.ConsumerWorkerReadCallback;
import io.confluent.kafkarest.KafkaRestConfig;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerWorker
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ConsumerWorker.class);
    KafkaRestConfig config;
    AtomicBoolean isRunning = new AtomicBoolean(true);
    CountDownLatch shutdownLatch = new CountDownLatch(1);
    Queue<ConsumerReadTask> tasks = new LinkedList<ConsumerReadTask>();
    Queue<ConsumerReadTask> waitingTasks = new PriorityQueue<ConsumerReadTask>(1, new ReadTaskExpirationComparator());

    public ConsumerWorker(KafkaRestConfig config) {
        this.config = config;
    }

    public synchronized <KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> Future readTopic(ConsumerState state, String topic, long maxBytes, ConsumerWorkerReadCallback<ClientKeyT, ClientValueT> callback) {
        ConsumerReadTask task = new ConsumerReadTask(state, topic, maxBytes, callback);
        log.trace("Scheduling consumer worker read worker={} task={} topic={} consumer={}", new Object[]{this, task, topic, state.getId()});
        if (!task.isDone()) {
            this.tasks.add(task);
            this.notifyAll();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning.get()) {
            ConsumerWorker consumerWorker = this;
            synchronized (consumerWorker) {
                long now;
                if (this.tasks.isEmpty()) {
                    try {
                        now = this.config.getTime().milliseconds();
                        long nextExpiration = this.nextWaitingExpiration();
                        if (nextExpiration > now) {
                            long timeout;
                            long l = timeout = nextExpiration == Long.MAX_VALUE ? 0L : nextExpiration - now;
                            assert (timeout >= 0L);
                            log.trace("Consumer worker waiting for next task worker={} timeout={}", (Object)this, (Object)timeout);
                            this.config.getTime().waitOn(this, timeout);
                        }
                    }
                    catch (InterruptedException now2) {
                        // empty catch block
                    }
                }
                now = this.config.getTime().milliseconds();
                while (this.nextWaitingExpiration() <= now) {
                    ConsumerReadTask waitingTask = this.waitingTasks.remove();
                    log.trace("Promoting waiting task to scheduled worker={} task={}", (Object)this, (Object)waitingTask);
                    this.tasks.add(waitingTask);
                }
                ConsumerReadTask task = this.tasks.poll();
                if (task != null) {
                    log.trace("Executing consumer read task worker={} task={}", (Object)this, (Object)task);
                    boolean backoff = task.doPartialRead();
                    if (!task.isDone()) {
                        if (backoff) {
                            log.trace("Rescheduling consumer read task with backoff worker={} task={}", (Object)this, (Object)task);
                            this.waitingTasks.add(task);
                        } else {
                            log.trace("Rescheduling consumer read task with immediately worker={} task={}", (Object)this, (Object)task);
                            this.tasks.add(task);
                        }
                    }
                }
            }
        }
        this.shutdownLatch.countDown();
    }

    private long nextWaitingExpiration() {
        if (this.waitingTasks.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.waitingTasks.peek().waitExpiration;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.interrupt();
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("Interrupted while consumer worker thread.");
            throw new Error("Interrupted when shutting down consumer worker thread.");
        }
    }

    private static class ReadTaskExpirationComparator
    implements Comparator<ConsumerReadTask> {
        private ReadTaskExpirationComparator() {
        }

        @Override
        public int compare(ConsumerReadTask t1, ConsumerReadTask t2) {
            if (t1.waitExpiration == t2.waitExpiration) {
                return 0;
            }
            if (t1.waitExpiration < t2.waitExpiration) {
                return -1;
            }
            return 1;
        }
    }
}

