/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.ConsumerReadTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;

public class ConsumerTopicState<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> {
    private final Lock lock = new ReentrantLock();
    private final KafkaStream<KafkaKeyT, KafkaValueT> stream;
    private final Map<Integer, Long> consumedOffsets;
    private final Map<Integer, Long> committedOffsets;
    private ConsumerReadTask failedTask;

    public ConsumerTopicState(KafkaStream<KafkaKeyT, KafkaValueT> stream) {
        this.stream = stream;
        this.consumedOffsets = new HashMap<Integer, Long>();
        this.committedOffsets = new HashMap<Integer, Long>();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public KafkaStream<KafkaKeyT, KafkaValueT> getStream() {
        return this.stream;
    }

    public ConsumerIterator<KafkaKeyT, KafkaValueT> getIterator() {
        return this.stream.iterator();
    }

    public Map<Integer, Long> getConsumedOffsets() {
        return this.consumedOffsets;
    }

    public Map<Integer, Long> getCommittedOffsets() {
        return this.committedOffsets;
    }

    public ConsumerReadTask clearFailedTask() {
        ConsumerReadTask t = this.failedTask;
        this.failedTask = null;
        return t;
    }

    public void setFailedTask(ConsumerReadTask failedTask) {
        this.failedTask = failedTask;
    }
}

