/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.BinaryConsumerRecord;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;

public class BinaryConsumerState
extends ConsumerState<byte[], byte[], byte[], byte[]> {
    private static final Deserializer<byte[]> deserializer = new ByteArrayDeserializer();

    public BinaryConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Properties consumerProperties, ConsumerManager.ConsumerFactory consumerFactory) {
        super(config, instanceId, consumerProperties, consumerFactory);
    }

    @Override
    protected Deserializer<byte[]> getKeyDeserializer() {
        return deserializer;
    }

    @Override
    protected Deserializer<byte[]> getValueDeserializer() {
        return deserializer;
    }

    @Override
    public ConsumerRecordAndSize<byte[], byte[]> convertConsumerRecord(ConsumerRecord<byte[], byte[]> msg) {
        long approxSize = (msg.key() != null ? ((byte[])msg.key()).length : 0) + (msg.value() != null ? ((byte[])msg.value()).length : 0);
        return new ConsumerRecordAndSize<byte[], byte[]>(new BinaryConsumerRecord((byte[])msg.key(), (byte[])msg.value(), msg.topic(), msg.partition(), msg.offset()), approxSize);
    }
}

