/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.converters.AvroConverter;
import io.confluent.kafkarest.entities.AvroConsumerRecord;
import java.util.Map;
import java.util.Properties;
import jersey.repackaged.com.google.common.collect.Maps;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.Deserializer;

public class AvroConsumerState
extends ConsumerState<Object, Object, JsonNode, JsonNode> {
    private Deserializer<Object> deserializer = null;

    public AvroConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Properties consumerProperties, ConsumerManager.ConsumerFactory consumerFactory) {
        super(config, instanceId, consumerProperties, consumerFactory);
    }

    private Deserializer<Object> initDeserializer() {
        if (this.deserializer == null) {
            Properties props = new Properties();
            props.setProperty("schema.registry.url", this.config.getString("schema.registry.url"));
            this.deserializer = new KafkaAvroDeserializer();
            this.deserializer.configure((Map)Maps.fromProperties((Properties)props), true);
        }
        return this.deserializer;
    }

    @Override
    protected Deserializer<Object> getKeyDeserializer() {
        return this.initDeserializer();
    }

    @Override
    protected Deserializer<Object> getValueDeserializer() {
        return this.initDeserializer();
    }

    @Override
    public ConsumerRecordAndSize<JsonNode, JsonNode> convertConsumerRecord(ConsumerRecord<Object, Object> msg) {
        AvroConverter.JsonNodeAndSize keyNode = AvroConverter.toJson(msg.key());
        AvroConverter.JsonNodeAndSize valueNode = AvroConverter.toJson(msg.value());
        return new ConsumerRecordAndSize<JsonNode, JsonNode>(new AvroConsumerRecord(keyNode.json, valueNode.json, msg.topic(), msg.partition(), msg.offset()), keyNode.size + valueNode.size);
    }
}

