/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.rest.exceptions.RestServerErrorException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jersey.repackaged.com.google.common.collect.ImmutableList;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;

public class AdminClientWrapper {
    private AdminClient adminClient;
    private int initTimeOut;
    private boolean isDefaultStreamSet;
    private String defaultStream;

    public AdminClientWrapper(KafkaRestConfig kafkaRestConfig) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)kafkaRestConfig.getAdminProperties());
        properties.put("bootstrap.servers", kafkaRestConfig.bootstrapBrokers());
        this.defaultStream = kafkaRestConfig.getString("streams.default.stream");
        boolean bl = this.isDefaultStreamSet = !"".equals(this.defaultStream);
        if (this.isDefaultStreamSet) {
            properties.put("streams.admin.default.stream", this.defaultStream);
        }
        this.adminClient = AdminClient.create((Properties)properties);
        this.initTimeOut = kafkaRestConfig.getInt("client.init.timeout.ms");
    }

    public List<Integer> getBrokerIds() {
        Vector<Integer> brokerIds = new Vector<Integer>();
        DescribeClusterResult clusterResults = this.adminClient.describeCluster();
        try {
            Collection nodeCollection = (Collection)clusterResults.nodes().get((long)this.initTimeOut, TimeUnit.MILLISECONDS);
            for (Node node : nodeCollection) {
                brokerIds.add(node.id());
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RestServerErrorException("Kafka error: ", 50002, (Throwable)e);
        }
        return brokerIds;
    }

    public Collection<String> getTopicNames() {
        TreeSet<String> allTopics = null;
        try {
            allTopics = new TreeSet<String>((Collection)this.adminClient.listTopics().names().get((long)this.initTimeOut, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RestServerErrorException("Kafka error: ", 50002, (Throwable)e);
        }
        return allTopics;
    }

    public Collection<String> getTopicNames(String streamName) {
        TreeSet<String> allTopics = null;
        try {
            allTopics = new TreeSet<String>((Collection)this.adminClient.listTopics(streamName).names().get((long)this.initTimeOut, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RestServerErrorException("Kafka error: ", 50002, (Throwable)e);
        }
        return allTopics;
    }

    public boolean topicExists(String topic) {
        if (!this.isDefaultStreamSet && this.isStreamTopic(topic)) {
            String streamName = topic.substring(0, topic.indexOf(":"));
            String topicName = topic.substring(topic.indexOf(":") + 1);
            Collection<String> allTopics = this.getTopicNames(streamName);
            return allTopics.contains(topicName);
        }
        Collection<String> allTopics = this.getTopicNames();
        return allTopics.contains(topic);
    }

    public Topic getTopic(String topicName) {
        Topic topic = null;
        if (this.topicExists(topicName)) {
            TopicDescription topicDescription = this.getTopicDescription(topicName);
            topic = this.buildTopic(topicName, topicDescription);
        }
        return topic;
    }

    public List<Partition> getTopicPartitions(String topicName) {
        TopicDescription topicDescription = this.getTopicDescription(topicName);
        List<Partition> partitions = this.buildPartitonsData(topicDescription.partitions(), null);
        return partitions;
    }

    public Partition getTopicPartition(String topicName, int partition) {
        TopicDescription topicDescription = this.getTopicDescription(topicName);
        List<Partition> partitions = this.buildPartitonsData(topicDescription.partitions(), partition);
        if (partitions.isEmpty()) {
            return null;
        }
        return partitions.get(0);
    }

    public boolean partitionExists(String topicName, int partition) {
        Topic topic = this.getTopic(topicName);
        return partition >= 0 && partition < topic.getPartitions().size();
    }

    private Topic buildTopic(String topicName, TopicDescription topicDescription) {
        List<Partition> partitions = this.buildPartitonsData(topicDescription.partitions(), null);
        Properties topicProps = new Properties();
        Topic topic = new Topic(topicName, topicProps, partitions);
        return topic;
    }

    private List<Partition> buildPartitonsData(List<TopicPartitionInfo> partitions, Integer partitionsFilter) {
        Vector<Partition> partitionList = new Vector<Partition>();
        for (TopicPartitionInfo topicPartitionInfo : partitions) {
            if (partitionsFilter != null && !partitionsFilter.equals(topicPartitionInfo.partition())) continue;
            Partition p = new Partition();
            p.setPartition(topicPartitionInfo.partition());
            p.setLeader(topicPartitionInfo.leader().id());
            Vector<PartitionReplica> partitionReplicas = new Vector<PartitionReplica>();
            for (Node replicaNode : topicPartitionInfo.replicas()) {
                partitionReplicas.add(new PartitionReplica(replicaNode.id(), replicaNode.id() == p.getLeader(), topicPartitionInfo.isr().contains(replicaNode)));
            }
            p.setReplicas(partitionReplicas);
            partitionList.add(p);
        }
        return partitionList;
    }

    private TopicDescription getTopicDescription(String topicName) throws RestServerErrorException {
        try {
            if (this.isDefaultStreamSet) {
                return (TopicDescription)((KafkaFuture)this.adminClient.describeTopics((Collection)ImmutableList.of((Object)topicName)).values().get(this.defaultStream + ":" + topicName)).get((long)this.initTimeOut, TimeUnit.MILLISECONDS);
            }
            return (TopicDescription)((KafkaFuture)this.adminClient.describeTopics((Collection)ImmutableList.of((Object)topicName)).values().get(topicName)).get((long)this.initTimeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RestServerErrorException("Kafka error: ", 50002, (Throwable)e);
        }
    }

    private boolean isStreamTopic(String topicName) {
        return topicName.startsWith("/") && topicName.contains(":");
    }

    public void shutdown() {
        this.adminClient.close();
    }
}

