/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.test.CustomOptions;
import io.confluent.kafka.serializers.protobuf.test.CustomOptions2;
import io.confluent.kafka.serializers.protobuf.test.DecimalValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.DecimalValuePb2OuterClass;
import io.confluent.kafka.serializers.protobuf.test.DependencyTestProto;
import io.confluent.kafka.serializers.protobuf.test.EnumReferenceOuter;
import io.confluent.kafka.serializers.protobuf.test.EnumRootOuter;
import io.confluent.kafka.serializers.protobuf.test.NestedTestProto;
import io.confluent.kafka.serializers.protobuf.test.Ranges;
import io.confluent.kafka.serializers.protobuf.test.TestMessageOptionalProtos;
import io.confluent.kafka.serializers.protobuf.test.TestMessageProtos;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.Assert;
import org.junit.Test;

public class KafkaProtobufSerializerTest {
    private final SchemaRegistryClient schemaRegistry;
    private final KafkaProtobufSerializer protobufSerializer;
    private final KafkaProtobufDeserializer protobufDeserializer;
    private final KafkaProtobufDeserializer deriveTypeDeserializer;
    private final KafkaProtobufDeserializer testMessageDeserializer;
    private final KafkaProtobufDeserializer nestedMessageDeserializer;
    private final KafkaProtobufDeserializer dependencyMessageDeserializer;
    private final KafkaProtobufDeserializer enumRefDeserializer;
    private final KafkaProtobufDeserializer innerMessageDeserializer;
    private final KafkaProtobufDeserializer optionalMessageDeserializer;
    private final String topic;
    private static final String TEST_MSG_STRING = "Hello World";
    private static final TestMessageProtos.TestMessage HELLO_WORLD_MESSAGE = TestMessageProtos.TestMessage.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final TestMessageProtos.TestMessage2 HELLO_WORLD_MESSAGE2 = TestMessageProtos.TestMessage2.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final NestedTestProto.UserId USER_ID = NestedTestProto.UserId.newBuilder().setKafkaUserId("user1").build();
    private static final NestedTestProto.ComplexType COMPLEX_TYPE = NestedTestProto.ComplexType.newBuilder().setOneId("complex").setIsActive(true).build();
    private static final Timestamp TS = Timestamp.newBuilder().setSeconds(1000L).setNanos(2000).build();
    private static final NestedTestProto.NestedMessage NESTED_MESSAGE = NestedTestProto.NestedMessage.newBuilder().setUserId(USER_ID).setIsActive(true).addExperimentsActive("first").addExperimentsActive("second").setUpdatedAt(TS).setStatus(NestedTestProto.Status.ACTIVE).setComplexType(COMPLEX_TYPE).putMapType("key1", "value1").putMapType("key2", "value2").build();
    private static final DependencyTestProto.DependencyMessage DEPENDENCY_MESSAGE = DependencyTestProto.DependencyMessage.newBuilder().setNestedMessage(NESTED_MESSAGE).setIsActive(true).setTestMesssage(HELLO_WORLD_MESSAGE).build();
    private static final EnumReferenceOuter.EnumReference ENUM_REF = EnumReferenceOuter.EnumReference.newBuilder().setEnumRoot(EnumRootOuter.EnumRoot.GOODBYE).build();
    private static final NestedTestProto.NestedMessage.InnerMessage INNER_MESSAGE = NestedTestProto.NestedMessage.InnerMessage.newBuilder().setId("inner").build();
    private static final TestMessageOptionalProtos.TestMessageOptional OPTIONAL_MESSAGE = TestMessageOptionalProtos.TestMessageOptional.newBuilder().setTestString("hi").build();
    private static final TestMessageOptionalProtos.TestMessageOptional OPTIONAL_MESSAGE_DEFAULT = TestMessageOptionalProtos.TestMessageOptional.newBuilder().setTestString("hi").setTestOptionalString("").build();
    private static final CustomOptions.CustomMessageOptions CUSTOM_MESSAGE_OPTIONS = CustomOptions.CustomMessageOptions.newBuilder().setTestString("hi").setTestInt(123).build();
    private static final CustomOptions2.FooBar FOO_BAR = CustomOptions2.FooBar.newBuilder().setFoo(123).build();

    public KafkaProtobufSerializerTest() {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        serializerConfig.put("normalize.schemas", (Object)true);
        serializerConfig.put("schema.format", "ignore_extensions");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.protobufSerializer = new KafkaProtobufSerializer(this.schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        this.protobufDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry);
        Properties deriveTypeDeserializerConfig = new Properties();
        deriveTypeDeserializerConfig.put("schema.registry.url", "bogus");
        deriveTypeDeserializerConfig.put("derive.type", (Object)true);
        this.deriveTypeDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(deriveTypeDeserializerConfig), null);
        Properties testMessageDeserializerConfig = new Properties();
        testMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.testMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(testMessageDeserializerConfig), TestMessageProtos.TestMessage.class);
        Properties nestedMessageDeserializerConfig = new Properties();
        nestedMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.nestedMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(nestedMessageDeserializerConfig), NestedTestProto.NestedMessage.class);
        Properties dependencyMessageDeserializerConfig = new Properties();
        dependencyMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.dependencyMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(dependencyMessageDeserializerConfig), DependencyTestProto.DependencyMessage.class);
        Properties enumRefDeserializerConfig = new Properties();
        enumRefDeserializerConfig.put("schema.registry.url", "bogus");
        this.enumRefDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(enumRefDeserializerConfig), EnumReferenceOuter.EnumReference.class);
        Properties innerMessageDeserializerConfig = new Properties();
        innerMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.innerMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(innerMessageDeserializerConfig), NestedTestProto.NestedMessage.InnerMessage.class);
        Properties optionalMessageDeserializerConfig = new Properties();
        optionalMessageDeserializerConfig.put("schema.registry.url", "bogus");
        this.optionalMessageDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, new HashMap<Object, Object>(optionalMessageDeserializerConfig), TestMessageOptionalProtos.TestMessageOptional.class);
        this.topic = "test";
    }

    public static Object getField(DynamicMessage message, String fieldName) {
        for (Map.Entry entry : message.getAllFields().entrySet()) {
            if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals(fieldName)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Test
    public void testKafkaProtobufSerializer() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.testMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.testMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE2);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE2);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)HELLO_WORLD_MESSAGE2.getTestInt32(), (Object)KafkaProtobufSerializerTest.getField(message, "test_int32"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)NESTED_MESSAGE);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.nestedMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)NESTED_MESSAGE);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)NESTED_MESSAGE);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)NESTED_MESSAGE.getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "user_id"), "kafka_user_id"));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.nestedMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)NESTED_MESSAGE, (Object)this.deriveTypeDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)NESTED_MESSAGE.getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "user_id"), "kafka_user_id"));
        bytes = this.protobufSerializer.serialize(this.topic, null);
        Assert.assertEquals(null, (Object)this.protobufDeserializer.deserialize(this.topic, bytes));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testKafkaJsonSchemaSerializerWithoutConfigure() {
        KafkaProtobufSerializer unconfiguredSerializer = new KafkaProtobufSerializer();
        unconfiguredSerializer.serialize(this.topic, (Message)HELLO_WORLD_MESSAGE);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testKafkaJsonSchemaDeserializerWithoutConfigure() {
        KafkaProtobufDeserializer unconfiguredSerializer = new KafkaProtobufDeserializer();
        byte[] randomBytes = "foo".getBytes();
        unconfiguredSerializer.deserialize("foo", randomBytes);
    }

    @Test
    public void testDependency() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)DEPENDENCY_MESSAGE);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE, (Object)this.dependencyMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)DEPENDENCY_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE.getNestedMessage().getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "nested_message"), "user_id"), "kafka_user_id"));
    }

    @Test
    public void testEnumRoot() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)ENUM_REF);
        Assert.assertEquals((Object)ENUM_REF, (Object)this.enumRefDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)ENUM_REF);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)ENUM_REF.getEnumRoot().name(), (Object)((Descriptors.EnumValueDescriptor)KafkaProtobufSerializerTest.getField(message, "enum_root")).getName());
    }

    @Test
    public void testInner() {
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)INNER_MESSAGE);
        Assert.assertEquals((Object)INNER_MESSAGE, (Object)this.innerMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)INNER_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)INNER_MESSAGE.getId(), (Object)KafkaProtobufSerializerTest.getField(message, "id"));
    }

    @Test
    public void testOptional() {
        String schemaString = "syntax = \"proto3\";\n\npackage io.confluent.kafka.serializers.protobuf.test;\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMessageOptionalProtos\";\n\nmessage TestMessageOptional {\n    string test_string = 1;\n    optional string test_optional_string = 2;\n}";
        ProtobufSchema schema = new ProtobufSchema(schemaString);
        Assert.assertEquals((Object)schema, (Object)new ProtobufSchema(schema.toDescriptor()));
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)OPTIONAL_MESSAGE);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE, (Object)this.optionalMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)OPTIONAL_MESSAGE);
        DynamicMessage message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)false, (Object)message.hasField(message.getDescriptorForType().findFieldByName("test_optional_string")));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE, (Object)this.optionalMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)false, (Object)message.hasField(message.getDescriptorForType().findFieldByName("test_optional_string")));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)OPTIONAL_MESSAGE_DEFAULT);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE_DEFAULT, (Object)this.optionalMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)OPTIONAL_MESSAGE_DEFAULT);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE_DEFAULT.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)true, (Object)message.hasField(message.getDescriptorForType().findFieldByName("test_optional_string")));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE_DEFAULT, (Object)this.optionalMessageDeserializer.deserialize(this.topic, bytes));
        bytes = this.protobufSerializer.serialize(this.topic, (Message)message);
        message = (DynamicMessage)this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)OPTIONAL_MESSAGE_DEFAULT.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)true, (Object)message.hasField(message.getDescriptorForType().findFieldByName("test_optional_string")));
        DynamicMessage.Builder builder = schema.newMessageBuilder();
        builder.setField(builder.getDescriptorForType().findFieldByName("test_string"), (Object)"hi");
        message = builder.build();
        Assert.assertEquals((Object)OPTIONAL_MESSAGE.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)false, (Object)message.hasField(message.getDescriptorForType().findFieldByName("test_optional_string")));
        builder = schema.newMessageBuilder();
        builder.setField(builder.getDescriptorForType().findFieldByName("test_string"), (Object)"hi");
        builder.setField(builder.getDescriptorForType().findFieldByName("test_optional_string"), (Object)"");
        message = builder.build();
        Assert.assertEquals((Object)OPTIONAL_MESSAGE_DEFAULT.getTestString(), (Object)KafkaProtobufSerializerTest.getField(message, "test_string"));
        Assert.assertEquals((Object)true, (Object)message.hasField(message.getDescriptorForType().findFieldByName("test_optional_string")));
    }

    @Test
    public void testCustomOptions() throws Exception {
        String expected = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nimport \"confluent/meta.proto\";\nimport \"google/protobuf/descriptor.proto\";\n\noption (io.confluent.kafka.serializers.protobuf.test.file_custom) = \"test\";\noption (io.confluent.kafka.serializers.protobuf.test.file_custom2) = \"hello\";\noption (io.confluent.kafka.serializers.protobuf.test.file_custom2) = \"world\";\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage CustomMessageOptions {\n  option (confluent.message_meta) = {\n    doc: \"message\"\n  };\n  option (io.confluent.kafka.serializers.protobuf.test.message_custom) = true;\n  option (io.confluent.kafka.serializers.protobuf.test.message_custom2) = true;\n  option (io.confluent.kafka.serializers.protobuf.test.message_custom2) = false;\n\n  string test_string = 1 [\n    (io.confluent.kafka.serializers.protobuf.test.field_custom) = 123,\n    (io.confluent.kafka.serializers.protobuf.test.field_custom2) = 456,\n    (io.confluent.kafka.serializers.protobuf.test.field_custom2) = 789\n  ];\n  int32 test_int = 2 [(confluent.field_meta) = {\n    doc: \"field\"\n  }];\n}\nmessage MyMessage {\n  int32 id = 1;\n  float f = 2;\n  double d = 3;\n  string doc = 4;\n  map<string, string> params = 5;\n  repeated int32 list = 6;\n}\nenum CustomEnumOptions {\n  option (confluent.enum_meta) = {\n    doc: \"enum\"\n  };\n  option (io.confluent.kafka.serializers.protobuf.test.enum_custom) = {\n    d: 456,\n    doc: \"hi\",\n    f: 123,\n    id: 1\n  };\n  option (io.confluent.kafka.serializers.protobuf.test.enum_custom2) = {\n    doc: \"hi\",\n    id: 2,\n    list: [\n      4,\n      5,\n      6\n    ],\n    params: {\n      key: \"hello\",\n      value: \"world\"\n    }\n  };\n  option (io.confluent.kafka.serializers.protobuf.test.enum_custom2) = {\n    doc: \"bye\",\n    id: 3,\n    list: [\n      7,\n      8,\n      9\n    ],\n    params: {\n      key: \"goodbye\",\n      value: \"world\"\n    }\n  };\n  CUSTOM0 = 0 [(io.confluent.kafka.serializers.protobuf.test.enum_value_custom) = ENUM1];\n  CUSTOM1 = 1 [\n    (io.confluent.kafka.serializers.protobuf.test.enum_value_custom2) = ENUM1,\n    (io.confluent.kafka.serializers.protobuf.test.enum_value_custom2) = ENUM2\n  ];\n  CUSTOM2 = 2 [(confluent.enum_value_meta) = {\n    doc: \"enum_value\"\n  }];\n}\nenum MyEnum {\n  ENUM0 = 0;\n  ENUM1 = 1;\n  ENUM2 = 2;\n}\n\nextend .google.protobuf.FileOptions {\n  string file_custom = 1111;\n  repeated string file_custom2 = 1112;\n}\nextend .google.protobuf.MessageOptions {\n  bool message_custom = 1111;\n  repeated bool message_custom2 = 1112;\n}\nextend .google.protobuf.FieldOptions {\n  int32 field_custom = 1111;\n  repeated int32 field_custom2 = 1112;\n}\nextend .google.protobuf.EnumOptions {\n  .io.confluent.kafka.serializers.protobuf.test.MyMessage enum_custom = 1111;\n  repeated .io.confluent.kafka.serializers.protobuf.test.MyMessage enum_custom2 = 1112;\n}\nextend .google.protobuf.EnumValueOptions {\n  .io.confluent.kafka.serializers.protobuf.test.MyEnum enum_value_custom = 1111;\n  repeated .io.confluent.kafka.serializers.protobuf.test.MyEnum enum_value_custom2 = 1112;\n}\n";
        ProtobufSchema schema = new ProtobufSchema(CustomOptions.CustomMessageOptions.getDescriptor());
        schema = schema.normalize();
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        schema = new ProtobufSchema(schema.canonicalString());
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        expected = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nimport \"confluent/meta.proto\";\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage CustomMessageOptions {\n  option (confluent.message_meta) = {\n    doc: \"message\"\n  };\n\n  string test_string = 1;\n  int32 test_int = 2 [(confluent.field_meta) = {\n    doc: \"field\"\n  }];\n}\nmessage MyMessage {\n  int32 id = 1;\n  float f = 2;\n  double d = 3;\n  string doc = 4;\n  map<string, string> params = 5;\n  repeated int32 list = 6;\n}\nenum CustomEnumOptions {\n  option (confluent.enum_meta) = {\n    doc: \"enum\"\n  };\n  CUSTOM0 = 0;\n  CUSTOM1 = 1;\n  CUSTOM2 = 2 [(confluent.enum_value_meta) = {\n    doc: \"enum_value\"\n  }];\n}\nenum MyEnum {\n  ENUM0 = 0;\n  ENUM1 = 1;\n  ENUM2 = 2;\n}\n";
        String noCustSchema = schema.formattedString(ProtobufSchema.Format.IGNORE_EXTENSIONS.symbol());
        Assert.assertEquals((Object)expected, (Object)noCustSchema);
        this.protobufSerializer.serialize(this.topic, (Message)CUSTOM_MESSAGE_OPTIONS);
        ParsedSchema retrievedSchema = this.schemaRegistry.getSchemaBySubjectAndId(this.topic + "-value", 1);
        Assert.assertEquals((Object)expected, (Object)retrievedSchema.canonicalString());
    }

    @Test
    public void testCustomOptions2() throws Exception {
        String expected = "package io.confluent.kafka.serializers.protobuf.test;\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage FooBar {\n  optional int32 foo = 1;\n  optional string bar = 2;\n  repeated .io.confluent.kafka.serializers.protobuf.test.FooBar nested = 3;\n\n  extensions 100 to 200;\n\n  extend .google.protobuf.EnumOptions {\n    optional string foobar_string = 71001;\n  }\n\n  message More {\n    option (io.confluent.kafka.serializers.protobuf.test.my_message_option) = {\n      [io.confluent.kafka.serializers.protobuf.test.FooBar.More.more_string]: \"foobar\",\n      [io.confluent.kafka.serializers.protobuf.test.rep]: [\n        FOO,\n        BAR\n      ]\n    };\n  \n    repeated int32 serial = 1;\n  \n    extend .io.confluent.kafka.serializers.protobuf.test.FooBar {\n      optional string more_string = 150;\n    }\n  }\n  message More2 {\n    option (io.confluent.kafka.serializers.protobuf.test.my_message_option) = {\n      [io.confluent.kafka.serializers.protobuf.test.FooBar.More2.more2_string]: \"foobar\",\n      foo: 123\n    };\n  \n    repeated int32 serial = 1;\n  \n    extend .io.confluent.kafka.serializers.protobuf.test.FooBar {\n      optional string more2_string = 151;\n    }\n  }\n  enum FooBarBazEnum {\n    option (io.confluent.kafka.serializers.protobuf.test.FooBar.foobar_string) = \"foobar\";\n    FOO = 1;\n    BAR = 2;\n    BAZ = 3;\n  }\n}\n\nextend .google.protobuf.MessageOptions {\n  optional .io.confluent.kafka.serializers.protobuf.test.FooBar my_message_option = 50001;\n}\nextend .io.confluent.kafka.serializers.protobuf.test.FooBar {\n  optional .io.confluent.kafka.serializers.protobuf.test.FooBar.FooBarBazEnum ext = 101;\n  repeated .io.confluent.kafka.serializers.protobuf.test.FooBar.FooBarBazEnum rep = 102;\n}\n";
        ProtobufSchema schema = new ProtobufSchema(CustomOptions2.FooBar.getDescriptor());
        schema = schema.normalize();
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        schema = new ProtobufSchema(schema.canonicalString());
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        expected = "package io.confluent.kafka.serializers.protobuf.test;\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage FooBar {\n  optional int32 foo = 1;\n  optional string bar = 2;\n  repeated .io.confluent.kafka.serializers.protobuf.test.FooBar nested = 3;\n\n  message More {\n    repeated int32 serial = 1;\n  }\n  message More2 {\n    repeated int32 serial = 1;\n  }\n  enum FooBarBazEnum {\n    FOO = 1;\n    BAR = 2;\n    BAZ = 3;\n  }\n}\n";
        String noCustSchema = schema.formattedString(ProtobufSchema.Format.IGNORE_EXTENSIONS.symbol());
        Assert.assertEquals((Object)expected, (Object)noCustSchema);
        this.protobufSerializer.serialize(this.topic, (Message)FOO_BAR);
        ParsedSchema retrievedSchema = this.schemaRegistry.getSchemaBySubjectAndId(this.topic + "-value", 1);
        Assert.assertEquals((Object)expected, (Object)retrievedSchema.canonicalString());
    }

    @Test
    public void testNormalizeBothPb2andPb3() throws Exception {
        String expected = "syntax = \"proto3\";\n\nimport \"confluent/meta.proto\";\nimport \"confluent/type/decimal.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage DecimalValue {\n  option (confluent.message_meta) = {\n    doc: \"message\"\n  };\n\n  .confluent.type.Decimal value = 1 [(confluent.field_meta) = {\n    params: [\n      {\n        key: \"precision\",\n        value: \"8\"\n      },\n      {\n        key: \"scale\",\n        value: \"3\"\n      }\n    ]\n  }];\n}\n";
        ProtobufSchema schema = new ProtobufSchema(DecimalValueOuterClass.DecimalValue.getDescriptor());
        schema = schema.normalize();
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        schema = new ProtobufSchema(schema.canonicalString());
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        expected = "\nimport \"confluent/meta.proto\";\nimport \"confluent/type/decimal.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage DecimalValuePb2 {\n  option (confluent.message_meta) = {\n    doc: \"message\"\n  };\n\n  optional .confluent.type.Decimal value = 1 [(confluent.field_meta) = {\n    params: [\n      {\n        key: \"precision\",\n        value: \"8\"\n      },\n      {\n        key: \"scale\",\n        value: \"3\"\n      }\n    ]\n  }];\n}\n";
        schema = new ProtobufSchema(DecimalValuePb2OuterClass.DecimalValuePb2.getDescriptor());
        schema = schema.normalize();
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        schema = new ProtobufSchema(schema.canonicalString());
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
    }

    @Test
    public void testRanges() {
        String expected = "package io.confluent.kafka.serializers.protobuf.test;\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nmessage FooBar {\n  reserved 5000 to 6000;\n  reserved 10000 to 10001;\n  reserved 20000;\n\n  optional int32 foo = 1;\n  optional string bar = 2;\n\n  extensions 100 to 200;\n  extensions 1000 to 1001;\n  extensions 2000;\n\n  enum FooBarBazEnum {\n    reserved 100 to 200;\n    reserved 1000 to 1001;\n    reserved 2000;\n    NONE = 0;\n    FOO = 1;\n    BAR = 2;\n    BAZ = 3;\n  }\n}\n";
        ProtobufSchema schema = new ProtobufSchema(Ranges.FooBar.getDescriptor());
        schema = schema.normalize();
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
        schema = new ProtobufSchema(schema.canonicalString());
        Assert.assertEquals((Object)expected, (Object)schema.canonicalString());
    }
}

