/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.rest;

import com.acme.glup.CommonProto;
import com.acme.glup.ExampleProtoAcme;
import com.acme.glup.MetadataProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.confluent.connect.protobuf.test.DescriptorRef;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerTest;
import io.confluent.kafka.serializers.protobuf.test.DependencyTestProto;
import io.confluent.kafka.serializers.protobuf.test.EnumReferenceOuter;
import io.confluent.kafka.serializers.protobuf.test.EnumRootOuter;
import io.confluent.kafka.serializers.protobuf.test.NestedTestProto;
import io.confluent.kafka.serializers.protobuf.test.TestMessageProtos;
import io.confluent.kafka.serializers.subject.DefaultReferenceSubjectNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class RestApiSerializerTest
extends ClusterTestHarness {
    private final String topic = "test";
    private static final String TEST_MSG_STRING = "Hello World";
    private static final TestMessageProtos.TestMessage HELLO_WORLD_MESSAGE = TestMessageProtos.TestMessage.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final NestedTestProto.UserId USER_ID = NestedTestProto.UserId.newBuilder().setKafkaUserId("user1").build();
    private static final NestedTestProto.ComplexType COMPLEX_TYPE = NestedTestProto.ComplexType.newBuilder().setOneId("complex").setIsActive(true).build();
    private static final Timestamp TS = Timestamp.newBuilder().setSeconds(1000L).setNanos(2000).build();
    private static final NestedTestProto.NestedMessage NESTED_MESSAGE = NestedTestProto.NestedMessage.newBuilder().setUserId(USER_ID).setIsActive(true).addExperimentsActive("first").addExperimentsActive("second").setUpdatedAt(TS).setStatus(NestedTestProto.Status.ACTIVE).setComplexType(COMPLEX_TYPE).putMapType("key1", "value1").putMapType("key2", "value2").build();
    private static final DependencyTestProto.DependencyMessage DEPENDENCY_MESSAGE = DependencyTestProto.DependencyMessage.newBuilder().setNestedMessage(NESTED_MESSAGE).setIsActive(true).setTestMesssage(HELLO_WORLD_MESSAGE).build();
    private static final MetadataProto.Origin ORIGIN_MESSAGE = MetadataProto.Origin.newBuilder().setDatacenter(MetadataProto.DataCenter.AM5).setIp4(1).setHostname("myhost").setContainerTask("mytask").setContainerApp("myapp").build();
    private static final MetadataProto.Partition PARTITION_MESSAGE = MetadataProto.Partition.newBuilder().setTimestampSeconds(1L).setHostPlatform(MetadataProto.Platform.US).setEventType(MetadataProto.EventType.Basket).build();
    private static final MetadataProto.ControlMessage.Watermark WATERMARK_MESSAGE = MetadataProto.ControlMessage.Watermark.newBuilder().setType("mytype").setHostname("myhost").setKafkaTopic("mytopic").setPartition(1).setPartitionCount(1).setProcessUuid(ByteString.EMPTY).setRegion("myregion").setTimestampSeconds(1).setCluster("mycluster").setEnvironment("myenv").build();
    private static final ExampleProtoAcme.ClickCas CLICK_CAS_MESSAGE = ExampleProtoAcme.ClickCas.newBuilder().setGlupOrigin(ORIGIN_MESSAGE).setPartition(PARTITION_MESSAGE).setUid("myuid").addControlMessage(WATERMARK_MESSAGE).build();
    private static final CommonProto.Consent CONSENT_MESSAGE = CommonProto.Consent.newBuilder().setIdentificationForbidden(true).build();
    private static final MetadataProto.DataSet DATA_SET_MESSAGE = MetadataProto.DataSet.newBuilder().setId("1").build();
    private static final EnumReferenceOuter.EnumReference ENUM_REF = EnumReferenceOuter.EnumReference.newBuilder().setEnumRoot(EnumRootOuter.EnumRoot.GOODBYE).build();

    public RestApiSerializerTest() {
        super(1, true);
    }

    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", ProtobufSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testDependency() throws Exception {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("normalize.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        serializerConfig.put("skip.known.types", (Object)false);
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        KafkaProtobufDeserializer protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
        Properties dependencyMessageDeserializerConfig = new Properties();
        dependencyMessageDeserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer dependencyMessageDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(dependencyMessageDeserializerConfig), DependencyTestProto.DependencyMessage.class);
        byte[] bytes = protobufSerializer.serialize("test", (Message)DEPENDENCY_MESSAGE);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE, (Object)dependencyMessageDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)DEPENDENCY_MESSAGE);
        DynamicMessage message = (DynamicMessage)protobufDeserializer.deserialize("test", bytes);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE.getNestedMessage().getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "nested_message"), "user_id"), "kafka_user_id"));
        ParsedSchema schema = schemaRegistry.getSchemaBySubjectAndId("test-value", 6);
        Assert.assertEquals((Object)ProtobufSchemaUtils.getSchema((Message)DEPENDENCY_MESSAGE).canonicalString(), (Object)schema.canonicalString());
        RestApiSerializerTest.checkNormalization((SchemaRegistryClient)schemaRegistry, "DependencyTestProto.proto");
    }

    @Test
    public void testDependencyPreregister() throws Exception {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("normalize.schemas", (Object)true);
        serializerConfig.put("reference.lookup.only", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        serializerConfig.put("skip.known.types", (Object)true);
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        serializerConfig.put("value.subject.name.strategy", TestReferenceNameStrategy.class);
        KafkaProtobufSerializer referenceSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        Properties deserializerConfig = new Properties();
        deserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer dataSetMessageDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(deserializerConfig), MetadataProto.DataSet.class);
        KafkaProtobufDeserializer consentMessageDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(deserializerConfig), CommonProto.Consent.class);
        byte[] bytes = referenceSerializer.serialize("test", (Message)DATA_SET_MESSAGE);
        Assert.assertEquals((Object)DATA_SET_MESSAGE, (Object)dataSetMessageDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)CONSENT_MESSAGE);
        Assert.assertEquals((Object)CONSENT_MESSAGE, (Object)consentMessageDeserializer.deserialize("test", bytes));
        RestApiSerializerTest.checkNormalization((SchemaRegistryClient)schemaRegistry, "common_proto.proto");
    }

    @Test
    public void testDependency2() throws Exception {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("normalize.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        serializerConfig.put("skip.known.types", (Object)false);
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        KafkaProtobufDeserializer protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
        Properties clickCasDeserializerConfig = new Properties();
        clickCasDeserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer clickCasDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(clickCasDeserializerConfig), ExampleProtoAcme.ClickCas.class);
        byte[] bytes = protobufSerializer.serialize("test", (Message)CLICK_CAS_MESSAGE);
        Assert.assertEquals((Object)CLICK_CAS_MESSAGE, (Object)clickCasDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)CLICK_CAS_MESSAGE);
        DynamicMessage message = (DynamicMessage)protobufDeserializer.deserialize("test", bytes);
        Assert.assertEquals((Object)CLICK_CAS_MESSAGE.getGlupOrigin().getHostname(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "glup_origin"), "hostname"));
        ParsedSchema schema = schemaRegistry.getSchemaBySubjectAndId("test-value", 4);
        Assert.assertEquals((Object)ProtobufSchemaUtils.getSchema((Message)CLICK_CAS_MESSAGE).normalize().canonicalString(), (Object)schema.normalize().canonicalString());
        RestApiSerializerTest.checkNormalization((SchemaRegistryClient)schemaRegistry, "exampleProtoAcme.proto");
    }

    @Test
    public void testWellKnownType() throws Exception {
        String schemaString = RestApiSerializerTest.getSchemaWithWellKnownType();
        String subject = "wellknown";
        RestApiSerializerTest.registerAndVerifySchema(this.restApp.restClient, schemaString, Collections.emptyList(), 1, subject, true);
        DescriptorRef.DescriptorMessage descMessage = DescriptorRef.DescriptorMessage.newBuilder().setKey(123).setValue(DescriptorRef.DescriptorMessage.getDescriptor().toProto()).build();
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("normalize.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        KafkaProtobufDeserializer protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
        Properties deserializerConfig = new Properties();
        deserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer descMessageDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(deserializerConfig), DescriptorRef.DescriptorMessage.class);
        byte[] bytes = protobufSerializer.serialize("test", (Message)descMessage);
        Assert.assertEquals((Object)descMessage, (Object)descMessageDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)descMessage);
        DynamicMessage message = (DynamicMessage)protobufDeserializer.deserialize("test", bytes);
        Assert.assertEquals((Object)descMessage.getKey(), (Object)KafkaProtobufSerializerTest.getField(message, "key"));
        ParsedSchema schema = schemaRegistry.getSchemaBySubjectAndId(subject, 1);
        Assert.assertEquals((Object)ProtobufSchemaUtils.getSchema((Message)descMessage).normalize().canonicalString(), (Object)schema.normalize().canonicalString());
        DefaultReferenceSubjectNameStrategy strategy = new DefaultReferenceSubjectNameStrategy();
        ProtobufSchema resolvedSchema = ProtobufSchemaUtils.getSchema((Message)descMessage);
        resolvedSchema = KafkaProtobufSerializer.resolveDependencies((SchemaRegistryClient)schemaRegistry, (boolean)false, (boolean)false, (boolean)true, null, (boolean)true, (ReferenceSubjectNameStrategy)strategy, (String)subject, (boolean)false, (ProtobufSchema)resolvedSchema);
        Assert.assertEquals((Object)schema.normalize(), (Object)resolvedSchema.normalize());
        RestApiSerializerTest.checkNormalization((SchemaRegistryClient)schemaRegistry, "DescriptorRef.proto");
    }

    @Test
    public void testSchemaReferencesConfigMetadata() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("configKey", "configValue");
        Metadata metadata = new Metadata(null, properties, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultMetadata(metadata);
        Assert.assertEquals((String)"Adding config with initial metadata should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        ProtobufSchema schema = ProtobufSchemaUtils.getSchema((Message)DEPENDENCY_MESSAGE);
        schema = AbstractKafkaProtobufSerializer.resolveDependencies((SchemaRegistryClient)schemaRegistry, (boolean)true, (boolean)false, (boolean)false, null, (ReferenceSubjectNameStrategy)new DefaultReferenceSubjectNameStrategy(), (String)"referrer", (boolean)false, (ProtobufSchema)schema);
        RegisterSchemaRequest request = new RegisterSchemaRequest((ParsedSchema)schema);
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer", false).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)4L, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(4);
        Assert.assertNotNull((String)"Registered schema should be found", (Object)schemaString);
        Assert.assertEquals((String)"Schema dependencies should be found", (long)2L, (long)schemaString.getReferences().size());
    }

    @Test(expected=RestClientException.class)
    public void testInvalidSchema() throws Exception {
        String schemaString = RestApiSerializerTest.getInvalidSchema();
        String subject = "invalid";
        RestApiSerializerTest.registerAndVerifySchema(this.restApp.restClient, schemaString, Collections.emptyList(), 1, subject);
    }

    private static String getInvalidSchema() {
        String schema = "syntax = \"proto3\";\n\noption java_outer_classname = \"InvalidSchema\";\noption java_package = \"io.confluent.connect.protobuf.test\";\n\nmessage MyMessage {\n  int32 key = 1;\n  .org.unknown.BadMessage value = 2;\n}";
        return schema;
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        RestApiSerializerTest.registerAndVerifySchema(restService, schemaString, references, expectedId, subject, false);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<SchemaReference> references, int expectedId, String subject, boolean normalize) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "PROTOBUF", references, subject, normalize).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemaString.trim(), (Object)restService.getId(expectedId).getSchemaString().trim());
    }

    private static String getSchemaWithWellKnownType() {
        String schema = "syntax = \"proto3\";\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_outer_classname = \"DescriptorRef\";\noption java_package = \"io.confluent.connect.protobuf.test\";\n\nmessage DescriptorMessage {\n  int32 key = 1;\n  .google.protobuf.DescriptorProto value = 2;\n}";
        return schema;
    }

    @Test
    public void testEnumRoot() throws Exception {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("normalize.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        KafkaProtobufDeserializer protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
        Properties enumRefDeserializerConfig = new Properties();
        enumRefDeserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer enumRefDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(enumRefDeserializerConfig), EnumReferenceOuter.EnumReference.class);
        byte[] bytes = protobufSerializer.serialize("test", (Message)ENUM_REF);
        Assert.assertEquals((Object)ENUM_REF, (Object)enumRefDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)ENUM_REF);
        DynamicMessage message = (DynamicMessage)protobufDeserializer.deserialize("test", bytes);
        Assert.assertEquals((Object)ENUM_REF.getEnumRoot().name(), (Object)((Descriptors.EnumValueDescriptor)KafkaProtobufSerializerTest.getField(message, "enum_root")).getName());
        ParsedSchema schema = schemaRegistry.getSchemaBySubjectAndId("test-value", 1);
        Assert.assertEquals((Object)new ProtobufSchema("syntax = \"proto3\";\n\noption java_outer_classname = \"EnumRootOuter\";\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\n\nenum EnumRoot {\n  HELLO = 0;\n  GOODBYE = 1;\n}").canonicalString(), (Object)schema.canonicalString());
        Assert.assertEquals((Object)"EnumRoot", (Object)schema.name());
        schema = schemaRegistry.getSchemaBySubjectAndId("test-value", 2);
        Assert.assertEquals((Object)ProtobufSchemaUtils.getSchema((Message)ENUM_REF).normalize().canonicalString(), (Object)schema.normalize().canonicalString());
        RestApiSerializerTest.checkNormalization((SchemaRegistryClient)schemaRegistry, "EnumReference.proto");
    }

    private static void checkNormalization(SchemaRegistryClient schemaRegistry, String fileName) throws Exception {
        Collection subjects = schemaRegistry.getAllSubjects();
        for (String subject : subjects) {
            ProtobufSchema proto2;
            SchemaMetadata metadata;
            Optional schema = schemaRegistry.parseSchema(new Schema(subject, metadata = schemaRegistry.getLatestSchemaMetadata(subject)));
            ProtobufSchema proto = (ProtobufSchema)schema.get();
            Descriptors.GenericDescriptor d = proto.toSpecificDescriptor(subject.endsWith(".proto") ? subject : fileName);
            if (d instanceof Descriptors.EnumDescriptor) {
                proto2 = new ProtobufSchema((Descriptors.EnumDescriptor)d);
            } else if (d instanceof Descriptors.Descriptor) {
                proto2 = new ProtobufSchema((Descriptors.Descriptor)d);
            } else if (d instanceof Descriptors.FileDescriptor) {
                proto2 = new ProtobufSchema((Descriptors.FileDescriptor)d);
            } else {
                throw new IllegalArgumentException();
            }
            proto2 = proto2.normalize();
            Assert.assertEquals((Object)metadata.getSchema(), (Object)proto2.canonicalString());
        }
    }

    public static class TestReferenceNameStrategy
    implements SubjectNameStrategy {
        public void configure(Map<String, ?> configs) {
        }

        public String subjectName(String topic, boolean isKey, ParsedSchema schema) {
            if (schema.name().endsWith("DataSet")) {
                return "metadata_proto.proto";
            }
            throw new IllegalArgumentException();
        }
    }
}

