/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.rest;

import com.acme.glup.ExampleProtoAcme;
import com.acme.glup.MetadataProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerTest;
import io.confluent.kafka.serializers.protobuf.test.DependencyTestProto;
import io.confluent.kafka.serializers.protobuf.test.NestedTestProto;
import io.confluent.kafka.serializers.protobuf.test.TestMessageProtos;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class RestApiSerializerTest
extends ClusterTestHarness {
    private final String topic = "test";
    private static final String TEST_MSG_STRING = "Hello World";
    private static final TestMessageProtos.TestMessage HELLO_WORLD_MESSAGE = TestMessageProtos.TestMessage.newBuilder().setTestString("Hello World").setTestInt32(123).build();
    private static final NestedTestProto.UserId USER_ID = NestedTestProto.UserId.newBuilder().setKafkaUserId("user1").build();
    private static final NestedTestProto.ComplexType COMPLEX_TYPE = NestedTestProto.ComplexType.newBuilder().setOneId("complex").setIsActive(true).build();
    private static final Timestamp TS = Timestamp.newBuilder().setSeconds(1000L).setNanos(2000).build();
    private static final NestedTestProto.NestedMessage NESTED_MESSAGE = NestedTestProto.NestedMessage.newBuilder().setUserId(USER_ID).setIsActive(true).addExperimentsActive("first").addExperimentsActive("second").setUpdatedAt(TS).setStatus(NestedTestProto.Status.ACTIVE).setComplexType(COMPLEX_TYPE).putMapType("key1", "value1").putMapType("key2", "value2").build();
    private static final DependencyTestProto.DependencyMessage DEPENDENCY_MESSAGE = DependencyTestProto.DependencyMessage.newBuilder().setNestedMessage(NESTED_MESSAGE).setIsActive(true).setTestMesssage(HELLO_WORLD_MESSAGE).build();
    private static final MetadataProto.Origin ORIGIN_MESSAGE = MetadataProto.Origin.newBuilder().setDatacenter(MetadataProto.DataCenter.AM5).setIp4(1).setHostname("myhost").setContainerTask("mytask").setContainerApp("myapp").build();
    private static final MetadataProto.Partition PARTITION_MESSAGE = MetadataProto.Partition.newBuilder().setTimestampSeconds(1L).setHostPlatform(MetadataProto.Platform.US).setEventType(MetadataProto.EventType.Basket).build();
    private static final MetadataProto.ControlMessage.Watermark WATERMARK_MESSAGE = MetadataProto.ControlMessage.Watermark.newBuilder().setType("mytype").setHostname("myhost").setKafkaTopic("mytopic").setPartition(1).setPartitionCount(1).setProcessUuid(ByteString.EMPTY).setRegion("myregion").setTimestampSeconds(1).setCluster("mycluster").setEnvironment("myenv").build();
    private static final ExampleProtoAcme.ClickCas CLICK_CAS_MESSAGE = ExampleProtoAcme.ClickCas.newBuilder().setGlupOrigin(ORIGIN_MESSAGE).setPartition(PARTITION_MESSAGE).setUid("myuid").addControlMessage(WATERMARK_MESSAGE).build();

    public RestApiSerializerTest() {
        super(1, true);
    }

    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", ProtobufSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testDependency() throws Exception {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        KafkaProtobufDeserializer protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
        Properties dependencyMessageDeserializerConfig = new Properties();
        dependencyMessageDeserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer dependencyMessageDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(dependencyMessageDeserializerConfig), DependencyTestProto.DependencyMessage.class);
        byte[] bytes = protobufSerializer.serialize("test", (Message)DEPENDENCY_MESSAGE);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE, (Object)dependencyMessageDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)DEPENDENCY_MESSAGE);
        DynamicMessage message = (DynamicMessage)protobufDeserializer.deserialize("test", bytes);
        Assert.assertEquals((Object)DEPENDENCY_MESSAGE.getNestedMessage().getUserId().getKafkaUserId(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "nested_message"), "user_id"), "kafka_user_id"));
        ParsedSchema schema = schemaRegistry.getSchemaBySubjectAndId("test-value", 6);
        Assert.assertEquals((Object)ProtobufSchemaUtils.getSchema((Message)DEPENDENCY_MESSAGE).canonicalString(), (Object)schema.canonicalString());
    }

    @Test
    public void testDependency2() throws Exception {
        Properties serializerConfig = new Properties();
        serializerConfig.put("auto.register.schemas", (Object)true);
        serializerConfig.put("schema.registry.url", "bogus");
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new ProtobufSchemaProvider()), Collections.emptyMap(), Collections.emptyMap());
        KafkaProtobufSerializer protobufSerializer = new KafkaProtobufSerializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(serializerConfig));
        KafkaProtobufDeserializer protobufDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry);
        Properties clickCasDeserializerConfig = new Properties();
        clickCasDeserializerConfig.put("schema.registry.url", "bogus");
        KafkaProtobufDeserializer clickCasDeserializer = new KafkaProtobufDeserializer((SchemaRegistryClient)schemaRegistry, new HashMap<Object, Object>(clickCasDeserializerConfig), ExampleProtoAcme.ClickCas.class);
        byte[] bytes = protobufSerializer.serialize("test", (Message)CLICK_CAS_MESSAGE);
        Assert.assertEquals((Object)CLICK_CAS_MESSAGE, (Object)clickCasDeserializer.deserialize("test", bytes));
        bytes = protobufSerializer.serialize("test", (Message)CLICK_CAS_MESSAGE);
        DynamicMessage message = (DynamicMessage)protobufDeserializer.deserialize("test", bytes);
        Assert.assertEquals((Object)CLICK_CAS_MESSAGE.getGlupOrigin().getHostname(), (Object)KafkaProtobufSerializerTest.getField((DynamicMessage)KafkaProtobufSerializerTest.getField(message, "glup_origin"), "hostname"));
        ParsedSchema schema = schemaRegistry.getSchemaBySubjectAndId("test-value", 4);
        Assert.assertEquals((Object)ProtobufSchemaUtils.getSchema((Message)CLICK_CAS_MESSAGE).canonicalString(), (Object)schema.canonicalString());
    }
}

