/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.google.common.base.Objects;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.EnumSchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.MessageSchemaDiff;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaDiff {
    public static final Set<Difference.Type> COMPATIBLE_CHANGES;

    public static List<Difference> compare(ProtobufSchema original, ProtobufSchema update) {
        Context ctx = new Context(COMPATIBLE_CHANGES);
        ctx.collectTypeInfo(original, true);
        ctx.collectTypeInfo(update, false);
        SchemaDiff.compare(ctx, original.rawSchema(), update.rawSchema());
        return ctx.getDifferences();
    }

    static void compare(Context ctx, ProtoFileElement original, ProtoFileElement update) {
        if (!Objects.equal((Object)original.getPackageName(), (Object)update.getPackageName())) {
            ctx.addDifference(Difference.Type.PACKAGE_CHANGED);
        }
        SchemaDiff.compareTypeElements(ctx, original.getTypes(), update.getTypes());
    }

    public static void compareTypeElements(Context ctx, List<TypeElement> original, List<TypeElement> update) {
        Context.NamedScope ignored;
        HashMap<String, MessageElement> originalMessages = new HashMap<String, MessageElement>();
        HashMap<String, MessageElement> updateMessages = new HashMap<String, MessageElement>();
        HashMap<String, Integer> originalMessageIndexes = new HashMap<String, Integer>();
        HashMap<String, Integer> updateMessageIndexes = new HashMap<String, Integer>();
        HashMap<String, EnumElement> originalEnums = new HashMap<String, EnumElement>();
        HashMap<String, EnumElement> updateEnums = new HashMap<String, EnumElement>();
        SchemaDiff.compareMessageElements(original, originalMessages, originalMessageIndexes, originalEnums);
        SchemaDiff.compareMessageElements(update, updateMessages, updateMessageIndexes, updateEnums);
        HashSet allMessageNames = new HashSet(originalMessages.keySet());
        allMessageNames.addAll(updateMessages.keySet());
        HashSet allEnumNames = new HashSet(originalEnums.keySet());
        allEnumNames.addAll(updateEnums.keySet());
        for (String name : allMessageNames) {
            ignored = ctx.enterName(name);
            try {
                MessageElement originalMessage = (MessageElement)originalMessages.get(name);
                MessageElement updateMessage = (MessageElement)updateMessages.get(name);
                if (updateMessage == null) {
                    Context.TypeElementInfo originalType = ctx.getType(name, true);
                    if (originalType == null || originalType.isMap()) continue;
                    ctx.addDifference(Difference.Type.MESSAGE_REMOVED);
                    continue;
                }
                if (originalMessage == null) {
                    Context.TypeElementInfo updateType = ctx.getType(name, false);
                    if (updateType == null || updateType.isMap()) continue;
                    ctx.addDifference(Difference.Type.MESSAGE_ADDED);
                    continue;
                }
                MessageSchemaDiff.compare(ctx, originalMessage, updateMessage);
                Integer originalMessageIndex = (Integer)originalMessageIndexes.get(name);
                Integer updateMessageIndex = (Integer)updateMessageIndexes.get(name);
                if (originalMessageIndex != null && originalMessageIndex.equals(updateMessageIndex)) continue;
                ctx.addDifference(Difference.Type.MESSAGE_MOVED);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        for (String name : allEnumNames) {
            ignored = ctx.enterName(name);
            try {
                EnumElement originalEnum = (EnumElement)originalEnums.get(name);
                EnumElement updateEnum = (EnumElement)updateEnums.get(name);
                if (updateEnum == null) {
                    ctx.addDifference(Difference.Type.ENUM_REMOVED);
                    continue;
                }
                if (originalEnum == null) {
                    ctx.addDifference(Difference.Type.ENUM_ADDED);
                    continue;
                }
                EnumSchemaDiff.compare(ctx, originalEnum, updateEnum);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
    }

    private static void compareMessageElements(List<TypeElement> types, Map<String, MessageElement> messages, Map<String, Integer> messageIndexes, Map<String, EnumElement> enums) {
        int index = 0;
        for (TypeElement typeElement : types) {
            if (typeElement instanceof MessageElement) {
                MessageElement messageElement = (MessageElement)typeElement;
                messages.put(messageElement.getName(), messageElement);
                messageIndexes.put(messageElement.getName(), index++);
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            EnumElement enumElement = (EnumElement)typeElement;
            enums.put(enumElement.getName(), enumElement);
        }
    }

    static {
        HashSet<Difference.Type> changes = new HashSet<Difference.Type>();
        changes.add(Difference.Type.PACKAGE_CHANGED);
        changes.add(Difference.Type.MESSAGE_ADDED);
        changes.add(Difference.Type.MESSAGE_MOVED);
        changes.add(Difference.Type.ENUM_ADDED);
        changes.add(Difference.Type.ENUM_REMOVED);
        changes.add(Difference.Type.ENUM_CONST_ADDED);
        changes.add(Difference.Type.ENUM_CONST_CHANGED);
        changes.add(Difference.Type.ENUM_CONST_REMOVED);
        changes.add(Difference.Type.FIELD_ADDED);
        changes.add(Difference.Type.FIELD_REMOVED);
        changes.add(Difference.Type.FIELD_NAME_CHANGED);
        changes.add(Difference.Type.FIELD_STRING_OR_BYTES_LABEL_CHANGED);
        changes.add(Difference.Type.ONEOF_ADDED);
        changes.add(Difference.Type.ONEOF_REMOVED);
        changes.add(Difference.Type.ONEOF_FIELD_ADDED);
        COMPATIBLE_CHANGES = Collections.unmodifiableSet(changes);
    }
}

