/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;

public class ServiceDefinition {
    private DescriptorProtos.ServiceDescriptorProto mServiceType;

    public static Builder newBuilder(String serviceName) {
        return new Builder(serviceName);
    }

    public String toString() {
        return this.mServiceType.toString();
    }

    DescriptorProtos.ServiceDescriptorProto getServiceType() {
        return this.mServiceType;
    }

    private ServiceDefinition(DescriptorProtos.ServiceDescriptorProto serviceType) {
        this.mServiceType = serviceType;
    }

    public static class Builder {
        private DescriptorProtos.ServiceDescriptorProto.Builder mServiceTypeBuilder = DescriptorProtos.ServiceDescriptorProto.newBuilder();

        public void addMethod(String name, String inputType, String outputType, Boolean clientStreaming, Boolean serverStreaming, Boolean isDeprecated, DescriptorProtos.MethodOptions.IdempotencyLevel idempotencyLevel) {
            DescriptorProtos.MethodOptions.Builder optionsBuilder;
            DescriptorProtos.MethodDescriptorProto.Builder methodBuilder = DescriptorProtos.MethodDescriptorProto.newBuilder();
            methodBuilder.setName(name).setInputType(inputType).setOutputType(outputType);
            if (clientStreaming != null) {
                methodBuilder.setClientStreaming(clientStreaming.booleanValue());
            }
            if (serverStreaming != null) {
                methodBuilder.setServerStreaming(serverStreaming.booleanValue());
            }
            if (isDeprecated != null) {
                optionsBuilder = DescriptorProtos.MethodOptions.newBuilder();
                optionsBuilder.setDeprecated(isDeprecated.booleanValue());
                methodBuilder.mergeOptions(optionsBuilder.build());
            }
            if (idempotencyLevel != null) {
                optionsBuilder = DescriptorProtos.MethodOptions.newBuilder();
                optionsBuilder.setIdempotencyLevel(idempotencyLevel);
                methodBuilder.mergeOptions(optionsBuilder.build());
            }
            this.mServiceTypeBuilder.addMethod(methodBuilder.build());
        }

        public Builder setDeprecated(boolean isDeprecated) {
            DescriptorProtos.ServiceOptions.Builder optionsBuilder = DescriptorProtos.ServiceOptions.newBuilder();
            optionsBuilder.setDeprecated(isDeprecated);
            this.mServiceTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public ServiceDefinition build() {
            return new ServiceDefinition(this.mServiceTypeBuilder.build());
        }

        private Builder(String serviceTypeName) {
            this.mServiceTypeBuilder.setName(serviceTypeName);
        }
    }
}

