/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.diff.ResourceLoader;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.MessageDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ProtobufSchemaTest {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final String recordSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMessageProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestMessage {\n    string test_string = 1 [json_name = \"test_str\"];\n    bool test_bool = 2;\n    bytes test_bytes = 3;\n    double test_double = 4;\n    float test_float = 5;\n    fixed32 test_fixed32 = 6;\n    fixed64 test_fixed64 = 7;\n    int32 test_int32 = 8;\n    int64 test_int64 = 9;\n    sfixed32 test_sfixed32 = 10;\n    sfixed64 test_sfixed64 = 11;\n    sint32 test_sint32 = 12;\n    sint64 test_sint64 = 13;\n    uint32 test_uint32 = 14;\n    uint64 test_uint64 = 15;\n}\n";
    private static final ProtobufSchema recordSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMessageProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestMessage {\n    string test_string = 1 [json_name = \"test_str\"];\n    bool test_bool = 2;\n    bytes test_bytes = 3;\n    double test_double = 4;\n    float test_float = 5;\n    fixed32 test_fixed32 = 6;\n    fixed64 test_fixed64 = 7;\n    int32 test_int32 = 8;\n    int64 test_int64 = 9;\n    sfixed32 test_sfixed32 = 10;\n    sfixed64 test_sfixed64 = 11;\n    sint32 test_sint32 = 12;\n    sint64 test_sint64 = 13;\n    uint32 test_uint32 = 14;\n    uint64 test_uint64 = 15;\n}\n");
    private static final String arraySchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestArrayProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestArray {\n    repeated string test_array = 1;\n}\n";
    private static final ProtobufSchema arraySchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestArrayProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestArray {\n    repeated string test_array = 1;\n}\n");
    private static final String mapSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMapProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestMap {\n    map<string, string> test_map = 1;\n}\n";
    private static final ProtobufSchema mapSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMapProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestMap {\n    map<string, string> test_map = 1;\n}\n");
    private static final String unionSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestUnionProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestUnion {\n    oneof test_oneof {\n        string name = 1;\n        int32 age = 2;\n    }\n}\n";
    private static final ProtobufSchema unionSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestUnionProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestUnion {\n    oneof test_oneof {\n        string name = 1;\n        int32 age = 2;\n    }\n}\n");
    private static final String enumSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestEnumProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestEnum {\n    enum Suit {\n        SPADES = 0;\n        HEARTS = 1;\n        DIAMONDS = 2;\n        CLUBS = 3;\n    }\n    Suit suit = 1;\n}\n";
    private static final ProtobufSchema enumSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestEnumProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestEnum {\n    enum Suit {\n        SPADES = 0;\n        HEARTS = 1;\n        DIAMONDS = 2;\n        CLUBS = 3;\n    }\n    Suit suit = 1;\n}\n");

    @Test
    public void testRecordToProtobuf() throws Exception {
        String json = "{\n    \"test_string\": \"string\",\n    \"test_bool\": true,\n    \"test_bytes\": \"aGVsbG8=\",\n    \"test_double\": 800.25,\n    \"test_float\": 23.4,\n    \"test_fixed32\": 32,\n    \"test_fixed64\": 64,\n    \"test_int32\": 32,\n    \"test_int64\": 64,\n    \"test_sfixed32\": 32,\n    \"test_sfixed64\": 64,\n    \"test_sint32\": 32,\n    \"test_sint64\": 64,\n    \"test_uint32\": 32,\n    \"test_uint64\": 64\n}";
        Object result = ProtobufSchemaUtils.toObject((JsonNode)ProtobufSchemaTest.jsonTree(json), (ProtobufSchema)recordSchema);
        Assert.assertTrue((boolean)(result instanceof DynamicMessage));
        DynamicMessage resultRecord = (DynamicMessage)result;
        Descriptors.Descriptor desc = resultRecord.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_string");
        Assert.assertEquals((Object)"string", (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_bool");
        Assert.assertEquals((Object)true, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_bytes");
        Assert.assertEquals((Object)"hello", (Object)((ByteString)resultRecord.getField(fd)).toStringUtf8());
        fd = desc.findFieldByName("test_double");
        Assert.assertEquals((Object)800.25, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_float");
        Assert.assertEquals((Object)Float.valueOf(23.4f), (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_fixed32");
        Assert.assertEquals((Object)32, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_fixed64");
        Assert.assertEquals((Object)64L, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_int32");
        Assert.assertEquals((Object)32, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_int64");
        Assert.assertEquals((Object)64L, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_sfixed32");
        Assert.assertEquals((Object)32, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_sfixed64");
        Assert.assertEquals((Object)64L, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_sint32");
        Assert.assertEquals((Object)32, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_sint64");
        Assert.assertEquals((Object)64L, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_uint32");
        Assert.assertEquals((Object)32, (Object)resultRecord.getField(fd));
        fd = desc.findFieldByName("test_uint64");
        Assert.assertEquals((Object)64L, (Object)resultRecord.getField(fd));
    }

    @Test
    public void testArrayToProtobuf() throws Exception {
        String json = "{ \"test_array\": [\"one\", \"two\", \"three\"] }";
        Object result = ProtobufSchemaUtils.toObject((JsonNode)ProtobufSchemaTest.jsonTree(json), (ProtobufSchema)arraySchema);
        Assert.assertTrue((boolean)(result instanceof DynamicMessage));
        DynamicMessage resultRecord = (DynamicMessage)result;
        Descriptors.Descriptor desc = resultRecord.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_array");
        Assert.assertArrayEquals((Object[])new String[]{"one", "two", "three"}, (Object[])((List)resultRecord.getField(fd)).toArray());
    }

    @Test
    public void testMapToProtobuf() throws Exception {
        String json = "{ \"test_map\": {\"first\": \"one\", \"second\": \"two\"} }";
        Object result = ProtobufSchemaUtils.toObject((JsonNode)ProtobufSchemaTest.jsonTree(json), (ProtobufSchema)mapSchema);
        Assert.assertTrue((boolean)(result instanceof DynamicMessage));
        DynamicMessage resultRecord = (DynamicMessage)result;
        Descriptors.Descriptor desc = resultRecord.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_map");
        Assert.assertEquals((long)2L, (long)((List)resultRecord.getField(fd)).size());
    }

    @Test
    public void testUnionToProtobuf() throws Exception {
        Object result = ProtobufSchemaUtils.toObject((JsonNode)ProtobufSchemaTest.jsonTree("{\"name\":\"test string\"}"), (ProtobufSchema)unionSchema);
        Assert.assertTrue((boolean)(result instanceof DynamicMessage));
        DynamicMessage resultRecord = (DynamicMessage)result;
        Descriptors.Descriptor desc = resultRecord.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("name");
        Assert.assertEquals((Object)"test string", (Object)resultRecord.getField(fd));
        result = ProtobufSchemaUtils.toObject((JsonNode)ProtobufSchemaTest.jsonTree("{\"age\":12}"), (ProtobufSchema)unionSchema);
        Assert.assertTrue((boolean)(result instanceof DynamicMessage));
        resultRecord = (DynamicMessage)result;
        desc = resultRecord.getDescriptorForType();
        fd = desc.findFieldByName("age");
        Assert.assertEquals((Object)12, (Object)resultRecord.getField(fd));
    }

    @Test
    public void testEnumToProtobuf() throws Exception {
        Object result = ProtobufSchemaUtils.toObject((JsonNode)ProtobufSchemaTest.jsonTree("{\"suit\":\"SPADES\"}"), (ProtobufSchema)enumSchema);
        DynamicMessage resultRecord = (DynamicMessage)result;
        Descriptors.Descriptor desc = resultRecord.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("suit");
        Assert.assertEquals((Object)"SPADES", (Object)resultRecord.getField(fd).toString());
    }

    @Test
    public void testRecordToJson() throws Exception {
        DynamicMessage.Builder builder = recordSchema.newMessageBuilder();
        Descriptors.Descriptor desc = builder.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_string");
        builder.setField(fd, (Object)"string");
        fd = desc.findFieldByName("test_bool");
        builder.setField(fd, (Object)true);
        fd = desc.findFieldByName("test_bytes");
        builder.setField(fd, (Object)ByteString.copyFromUtf8((String)"hello"));
        fd = desc.findFieldByName("test_double");
        builder.setField(fd, (Object)800.25);
        fd = desc.findFieldByName("test_float");
        builder.setField(fd, (Object)Float.valueOf(23.4f));
        fd = desc.findFieldByName("test_fixed32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_fixed64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_int32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_int64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_sfixed32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_sfixed64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_sint32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_sint64");
        builder.setField(fd, (Object)64L);
        fd = desc.findFieldByName("test_uint32");
        builder.setField(fd, (Object)32);
        fd = desc.findFieldByName("test_uint64");
        builder.setField(fd, (Object)64L);
        DynamicMessage message = builder.build();
        JsonNode result = objectMapper.readTree(ProtobufSchemaUtils.toJson((Message)message));
        Assert.assertTrue((boolean)result.isObject());
        Assert.assertTrue((boolean)result.get("test_str").isTextual());
        Assert.assertEquals((Object)"string", (Object)result.get("test_str").textValue());
        Assert.assertTrue((boolean)result.get("testBool").isBoolean());
        Assert.assertEquals((Object)true, (Object)result.get("testBool").booleanValue());
        Assert.assertTrue((boolean)result.get("testBytes").isTextual());
        Assert.assertEquals((Object)"aGVsbG8=", (Object)result.get("testBytes").textValue());
        Assert.assertTrue((boolean)result.get("testDouble").isDouble());
        Assert.assertEquals((double)800.25, (double)result.get("testDouble").doubleValue(), (double)0.01);
        Assert.assertTrue((boolean)result.get("testFloat").isDouble());
        Assert.assertEquals((double)23.4f, (double)result.get("testFloat").doubleValue(), (double)0.1);
        Assert.assertTrue((boolean)result.get("testFixed32").isInt());
        Assert.assertEquals((long)32L, (long)result.get("testFixed32").intValue());
        Assert.assertTrue((boolean)result.get("testFixed64").isTextual());
        Assert.assertEquals((Object)"64", (Object)result.get("testFixed64").textValue());
        Assert.assertTrue((boolean)result.get("testInt32").isInt());
        Assert.assertEquals((long)32L, (long)result.get("testInt32").intValue());
        Assert.assertTrue((boolean)result.get("testInt64").isTextual());
        Assert.assertEquals((Object)"64", (Object)result.get("testInt64").textValue());
        Assert.assertTrue((boolean)result.get("testSfixed32").isInt());
        Assert.assertEquals((long)32L, (long)result.get("testSfixed32").intValue());
        Assert.assertTrue((boolean)result.get("testSfixed64").isTextual());
        Assert.assertEquals((Object)"64", (Object)result.get("testSfixed64").textValue());
        Assert.assertTrue((boolean)result.get("testSint32").isInt());
        Assert.assertEquals((long)32L, (long)result.get("testSint32").intValue());
        Assert.assertTrue((boolean)result.get("testSint64").isTextual());
        Assert.assertEquals((Object)"64", (Object)result.get("testSint64").textValue());
        Assert.assertTrue((boolean)result.get("testUint32").isInt());
        Assert.assertEquals((long)32L, (long)result.get("testUint32").intValue());
        Assert.assertTrue((boolean)result.get("testUint64").isTextual());
        Assert.assertEquals((Object)"64", (Object)result.get("testUint64").textValue());
    }

    @Test
    public void testArrayToJson() throws Exception {
        DynamicMessage.Builder builder = arraySchema.newMessageBuilder();
        Descriptors.Descriptor desc = builder.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_array");
        builder.setField(fd, Arrays.asList("one", "two", "three"));
        DynamicMessage message = builder.build();
        JsonNode result = objectMapper.readTree(ProtobufSchemaUtils.toJson((Message)message));
        JsonNode fieldNode = result.get("testArray");
        Assert.assertTrue((boolean)fieldNode.isArray());
        Assert.assertEquals((long)3L, (long)fieldNode.size());
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("one"), (Object)fieldNode.get(0));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("two"), (Object)fieldNode.get(1));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("three"), (Object)fieldNode.get(2));
    }

    @Test
    public void testMapToJson() throws Exception {
        DynamicMessage.Builder mapBuilder = mapSchema.newMessageBuilder("TestMap.TestMapEntry");
        Descriptors.Descriptor mapDesc = mapBuilder.getDescriptorForType();
        Descriptors.FieldDescriptor keyField = mapDesc.findFieldByName("key");
        mapBuilder.setField(keyField, (Object)"first");
        Descriptors.FieldDescriptor valueField = mapDesc.findFieldByName("value");
        mapBuilder.setField(valueField, (Object)"one");
        DynamicMessage mapEntry = mapBuilder.build();
        DynamicMessage.Builder mapBuilder2 = mapSchema.newMessageBuilder("TestMap.TestMapEntry");
        Descriptors.Descriptor mapDesc2 = mapBuilder2.getDescriptorForType();
        Descriptors.FieldDescriptor keyField2 = mapDesc2.findFieldByName("key");
        mapBuilder2.setField(keyField2, (Object)"second");
        Descriptors.FieldDescriptor valueField2 = mapDesc2.findFieldByName("value");
        mapBuilder2.setField(valueField2, (Object)"two");
        DynamicMessage mapEntry2 = mapBuilder2.build();
        DynamicMessage.Builder builder = mapSchema.newMessageBuilder();
        Descriptors.Descriptor desc = builder.getDescriptorForType();
        Descriptors.FieldDescriptor fd = desc.findFieldByName("test_map");
        builder.setField(fd, Arrays.asList(mapEntry, mapEntry2));
        DynamicMessage message = builder.build();
        JsonNode result = objectMapper.readTree(ProtobufSchemaUtils.toJson((Message)message));
        JsonNode fieldNode = result.get("testMap");
        Assert.assertEquals((long)2L, (long)fieldNode.size());
        Assert.assertNotNull((Object)fieldNode.get("first"));
        Assert.assertEquals((Object)"one", (Object)fieldNode.get("first").asText());
        Assert.assertNotNull((Object)fieldNode.get("second"));
        Assert.assertEquals((Object)"two", (Object)fieldNode.get("second").asText());
    }

    @Test
    public void testFileDescriptorProto() throws Exception {
        ResourceLoader resourceLoader = new ResourceLoader("/io/confluent/kafka/schemaregistry/protobuf/diff/");
        ProtoFileElement original = resourceLoader.readObj("TestProto.proto");
        ProtobufSchema schema = new ProtobufSchema(original.toSchema());
        String fileProto = schema.formattedString("serialized");
        ProtobufSchema schema2 = new ProtobufSchema(fileProto);
        Assert.assertTrue((boolean)schema.isCompatible(CompatibilityLevel.BACKWARD, Collections.singletonList(schema2)));
        fileProto = schema2.formattedString("serialized");
        ProtobufSchema schema3 = new ProtobufSchema(fileProto);
        Assert.assertTrue((boolean)schema2.isCompatible(CompatibilityLevel.BACKWARD, Collections.singletonList(schema3)));
        Assert.assertEquals((Object)schema2, (Object)schema3);
        original = resourceLoader.readObj("NestedTestProto.proto");
        schema = new ProtobufSchema(original.toSchema());
        fileProto = schema.formattedString("serialized");
        schema2 = new ProtobufSchema(fileProto);
        Assert.assertTrue((boolean)schema.isCompatible(CompatibilityLevel.BACKWARD, Collections.singletonList(schema2)));
        fileProto = schema2.formattedString("serialized");
        schema3 = new ProtobufSchema(fileProto);
        Assert.assertTrue((boolean)schema2.isCompatible(CompatibilityLevel.BACKWARD, Collections.singletonList(schema3)));
        Assert.assertEquals((Object)schema2, (Object)schema3);
    }

    @Test
    public void testDefaultOmittedInProto3String() throws Exception {
        MessageDefinition.Builder message = MessageDefinition.newBuilder((String)"msg1");
        message.addField(null, "string", "field1", 1, "defaultVal");
        DynamicSchema.Builder schema = DynamicSchema.newBuilder();
        schema.setSyntax("proto3");
        schema.addMessageDefinition(message.build());
        ProtobufSchema protobufSchema = new ProtobufSchema(schema.build().getMessageDescriptor("msg1"));
        Assert.assertEquals((Object)"syntax = \"proto3\";\n\nmessage msg1 {\n  string field1 = 1;\n}\n", (Object)protobufSchema.toString());
    }

    private static JsonNode jsonTree(String jsonData) {
        try {
            return objectMapper.readTree(jsonData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON", e);
        }
    }
}

