/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.ResourceLoader;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SchemaDiffTest {
    private static final String badMessageSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMapProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestBadMessage {\n    bad.Message test_bad_message = 1;\n}\n";
    private static final ProtobufSchema badMessageSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMapProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestBadMessage {\n    bad.Message test_bad_message = 1;\n}\n");

    @Test
    public void checkProtobufSchemaCompatibility() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode nodes = (ArrayNode)objectMapper.readTree(SchemaDiffTest.readFile("diff-schema-examples.json"));
        for (int i = 0; i < nodes.size(); ++i) {
            ObjectNode testCase = (ObjectNode)nodes.get(i);
            String originalSchema = testCase.get("original_schema").asText();
            String updateSchema = testCase.get("update_schema").asText();
            ProtoFileElement original = ProtoParser.Companion.parse(Location.get((String)"unknown"), originalSchema);
            ProtoFileElement update = ProtoParser.Companion.parse(Location.get((String)"unknown"), updateSchema);
            ArrayList<SchemaReference> originalSchemaRefs = new ArrayList<SchemaReference>();
            ArrayNode originalRefs = (ArrayNode)testCase.get("original_references");
            if (originalRefs != null) {
                for (JsonNode ref : originalRefs) {
                    ObjectNode node = (ObjectNode)ref;
                    SchemaReference schemaRef = new SchemaReference(node.get("name").asText(), node.get("subject").asText(), Integer.valueOf(node.get("version").asInt()));
                    originalSchemaRefs.add(schemaRef);
                }
            }
            ArrayList<SchemaReference> updateSchemaRefs = new ArrayList<SchemaReference>();
            ArrayNode updateRefs = (ArrayNode)testCase.get("update_references");
            if (updateRefs != null) {
                for (JsonNode ref : updateRefs) {
                    ObjectNode node = (ObjectNode)ref;
                    SchemaReference schemaRef = new SchemaReference(node.get("name").asText(), node.get("subject").asText(), Integer.valueOf(node.get("version").asInt()));
                    updateSchemaRefs.add(schemaRef);
                }
            }
            HashMap<String, ProtoFileElement> originalDependencies = new HashMap<String, ProtoFileElement>();
            ArrayNode originalDeps = (ArrayNode)testCase.get("original_dependencies");
            if (originalDeps != null) {
                for (JsonNode dep : originalDeps) {
                    ObjectNode node = (ObjectNode)dep;
                    String schema = node.get("dependency").asText();
                    ProtoFileElement file = ProtoParser.Companion.parse(Location.get((String)"unknown"), schema);
                    originalDependencies.put(node.get("name").asText(), file);
                }
            }
            HashMap<String, ProtoFileElement> updateDependencies = new HashMap<String, ProtoFileElement>();
            ArrayNode updateDeps = (ArrayNode)testCase.get("update_dependencies");
            if (updateDeps != null) {
                for (JsonNode dep : updateDeps) {
                    ObjectNode node = (ObjectNode)dep;
                    String schema = node.get("dependency").asText();
                    ProtoFileElement file = ProtoParser.Companion.parse(Location.get((String)"unknown"), schema);
                    updateDependencies.put(node.get("name").asText(), file);
                }
            }
            ArrayNode changes = (ArrayNode)testCase.get("changes");
            boolean isCompatible = testCase.get("compatible").asBoolean();
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (int j = 0; j < changes.size(); ++j) {
                errorMessages.add(changes.get(j).asText());
            }
            String description = testCase.get("description").asText();
            List differences = SchemaDiff.compare((ProtobufSchema)new ProtobufSchema(original, originalSchemaRefs, originalDependencies), (ProtobufSchema)new ProtobufSchema(update, updateSchemaRefs, updateDependencies));
            List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains(diff.getType())).collect(Collectors.toList());
            Assert.assertThat((String)description, differences.stream().map(change -> change.getType().toString() + " " + change.getFullPath()).collect(Collectors.toList()), (Matcher)CoreMatchers.is(errorMessages));
            Assert.assertEquals((String)description, (Object)isCompatible, (Object)incompatibleDiffs.isEmpty());
        }
    }

    @Test
    public void checkCompatibilityUsingProtoFiles() throws Exception {
        ResourceLoader resourceLoader = new ResourceLoader("/io/confluent/kafka/schemaregistry/protobuf/diff/");
        ProtoFileElement original = resourceLoader.readObj("TestProto.proto");
        ProtoFileElement update = resourceLoader.readObj("TestProto2.proto");
        List changes = SchemaDiff.compare((ProtobufSchema)new ProtobufSchema(original, Collections.emptyList(), Collections.emptyMap()), (ProtobufSchema)new ProtobufSchema(update, Collections.emptyList(), Collections.emptyMap()));
        Assert.assertTrue((boolean)changes.contains(new Difference(Difference.Type.FIELD_NAME_CHANGED, "#/TestMessage/2")));
        Assert.assertTrue((boolean)changes.contains(new Difference(Difference.Type.FIELD_SCALAR_KIND_CHANGED, "#/TestMessage/2")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkCompatibilityUsingBadMessage() throws Exception {
        SchemaDiff.compare((ProtobufSchema)badMessageSchema, (ProtobufSchema)badMessageSchema);
    }

    private static String readFile(String fileName) {
        ResourceLoader resourceLoader = new ResourceLoader("/");
        return resourceLoader.toString(fileName);
    }
}

