/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.MessageSchemaDiff;
import java.util.Objects;

public class FieldSchemaDiff {
    static void compare(Context ctx, FieldElement original, FieldElement update) {
        if (!Objects.equals(original.getName(), update.getName())) {
            ctx.addDifference(Difference.Type.FIELD_NAME_CHANGED);
        }
        ProtoType originalType = ProtoType.get((String)original.getType());
        ProtoType updateType = ProtoType.get((String)update.getType());
        FieldSchemaDiff.compareTypes(ctx, originalType, updateType);
    }

    static void compareTypes(Context ctx, ProtoType original, ProtoType update) {
        Kind updateKind;
        Kind originalKind;
        Context.TypeElementInfo updateType;
        Context.TypeElementInfo originalType = ctx.getType(original.toString(), true);
        if (originalType != null && originalType.isMap()) {
            original = originalType.getMapType();
        }
        if ((updateType = ctx.getType(update.toString(), true)) != null && updateType.isMap()) {
            update = updateType.getMapType();
        }
        if (!Objects.equals((Object)(originalKind = FieldSchemaDiff.kind(ctx, original, true)), (Object)(updateKind = FieldSchemaDiff.kind(ctx, update, false)))) {
            ctx.addDifference(Difference.Type.FIELD_KIND_CHANGED);
        } else {
            switch (originalKind) {
                case SCALAR: {
                    FieldSchemaDiff.compareScalarTypes(ctx, original, update);
                    break;
                }
                case MESSAGE: {
                    FieldSchemaDiff.compareMessageTypes(ctx, original, update);
                    break;
                }
                case MAP: {
                    FieldSchemaDiff.compareMapTypes(ctx, original, update);
                    break;
                }
            }
        }
    }

    static void compareScalarTypes(Context ctx, ProtoType original, ProtoType update) {
        if (!Objects.equals((Object)FieldSchemaDiff.scalarKind(ctx, original, true), (Object)FieldSchemaDiff.scalarKind(ctx, update, false))) {
            ctx.addDifference(Difference.Type.FIELD_SCALAR_KIND_CHANGED);
        }
    }

    static void compareMessageTypes(Context ctx, ProtoType original, ProtoType update) {
        String updateLocalName;
        String originalFullName = ctx.resolve(original.toString(), true);
        if (originalFullName == null) {
            throw new IllegalArgumentException("Could not resolve message type: " + original.toString());
        }
        String updateFullName = ctx.resolve(update.toString(), false);
        if (updateFullName == null) {
            throw new IllegalArgumentException("Could not resolve message type: " + update.toString());
        }
        Context.TypeElementInfo originalType = ctx.getType(originalFullName, true);
        Context.TypeElementInfo updateType = ctx.getType(updateFullName, false);
        String originalLocalName = originalFullName.startsWith(originalType.packageName() + ".") ? originalFullName.substring(originalType.packageName().length() + 1) : originalFullName;
        String string = updateLocalName = updateFullName.startsWith(updateType.packageName() + ".") ? updateFullName.substring(updateType.packageName().length() + 1) : updateFullName;
        if (!Objects.equals(originalLocalName, updateLocalName)) {
            ctx.addDifference(Difference.Type.FIELD_NAMED_TYPE_CHANGED);
        } else {
            SchemaReference originalRef = originalType.reference();
            SchemaReference updateRef = updateType.reference();
            if (!originalRef.getSubject().equals(updateRef.getSubject()) || !originalRef.getVersion().equals(updateRef.getVersion())) {
                Context subctx = ctx.getSubcontext();
                subctx.setPackageName(originalType.packageName(), true);
                subctx.setPackageName(updateType.packageName(), false);
                subctx.setFullName(originalLocalName);
                MessageSchemaDiff.compare(subctx, (MessageElement)originalType.type(), (MessageElement)updateType.type());
                ctx.addDifferences(subctx.getDifferences());
                if (!subctx.isCompatible()) {
                    ctx.addDifference(Difference.Type.FIELD_NAMED_TYPE_CHANGED);
                }
            }
        }
    }

    static void compareMapTypes(Context ctx, ProtoType original, ProtoType update) {
        FieldSchemaDiff.compareTypes(ctx, original.getKeyType(), update.getKeyType());
        FieldSchemaDiff.compareTypes(ctx, original.getValueType(), update.getValueType());
    }

    static Kind kind(Context ctx, ProtoType type, boolean isOriginal) {
        if (type.isScalar()) {
            return Kind.SCALAR;
        }
        if (type.isMap()) {
            return Kind.MAP;
        }
        Context.TypeElementInfo typeInfo = ctx.getType(type.toString(), isOriginal);
        if (typeInfo != null && typeInfo.type() instanceof EnumElement) {
            return Kind.SCALAR;
        }
        return Kind.MESSAGE;
    }

    static ScalarKind scalarKind(Context ctx, ProtoType type, boolean isOriginal) {
        Context.TypeElementInfo typeInfo = ctx.getType(type.toString(), isOriginal);
        if (typeInfo != null && typeInfo.type() instanceof EnumElement) {
            return ScalarKind.GENERAL_NUMBER;
        }
        switch (type.toString()) {
            case "int32": 
            case "int64": 
            case "uint32": 
            case "uint64": 
            case "bool": {
                return ScalarKind.GENERAL_NUMBER;
            }
            case "sint32": 
            case "sint64": {
                return ScalarKind.SIGNED_NUMBER;
            }
            case "string": 
            case "bytes": {
                return ScalarKind.STRING_OR_BYTES;
            }
            case "fixed32": 
            case "sfixed32": {
                return ScalarKind.FIXED32;
            }
            case "fixed64": 
            case "sfixed64": {
                return ScalarKind.FIXED64;
            }
            case "float": {
                return ScalarKind.FLOAT;
            }
            case "double": {
                return ScalarKind.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    static enum ScalarKind {
        GENERAL_NUMBER,
        SIGNED_NUMBER,
        STRING_OR_BYTES,
        FIXED32,
        FIXED64,
        FLOAT,
        DOUBLE,
        ANY;

    }

    static enum Kind {
        SCALAR,
        MAP,
        MESSAGE;

    }
}

