/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.confluent.kafka.serializers.KafkaJsonSerializerConfig;
import io.confluent.kafka.serializers.jackson.Jackson;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaJsonSerializer<T>
implements Serializer<T> {
    private ObjectMapper objectMapper;

    public void configure(Map<String, ?> config, boolean isKey) {
        this.configure(new KafkaJsonSerializerConfig(config));
    }

    protected void configure(KafkaJsonSerializerConfig config) {
        this.objectMapper = Jackson.newObjectMapper();
        boolean prettyPrint = config.getBoolean("json.indent.output");
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
        boolean writeDatesAsIso8601 = config.getBoolean("json.write.dates.iso8601");
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, !writeDatesAsIso8601);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", (Throwable)e);
        }
    }

    public void close() {
    }
}

