/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.serializers.KafkaJsonSerializer;
import io.confluent.kafka.serializers.jackson.Jackson;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KafkaJsonSerializerTest {
    private ObjectMapper objectMapper = Jackson.newObjectMapper();
    private KafkaJsonSerializer<Object> serializer;

    @Before
    public void setup() {
        this.serializer = new KafkaJsonSerializer();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("json.write.dates.iso8601", true);
        this.serializer.configure(config, false);
    }

    @Test
    public void serializeNull() {
        Assert.assertNull((Object)this.serializer.serialize("foo", null));
    }

    @Test
    public void serialize() throws Exception {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("foo", "bar");
        message.put("baz", 354.99);
        byte[] bytes = this.serializer.serialize("foo", message);
        Object deserialized = this.objectMapper.readValue(bytes, Object.class);
        Assert.assertEquals(message, (Object)deserialized);
    }

    @Test
    public void serializeUser() throws Exception {
        User user = new User("john", "doe", 50, "jack", LocalDate.parse("2018-12-27"));
        byte[] bytes = this.serializer.serialize("foo", (Object)user);
        Object deserialized = this.objectMapper.readValue(bytes, User.class);
        Assert.assertEquals((Object)user, (Object)deserialized);
    }

    public static class User {
        @JsonProperty
        public String firstName;
        @JsonProperty
        public String lastName;
        @JsonProperty
        public short age;
        @JsonProperty
        public Optional<String> nickName;
        @JsonProperty
        public LocalDate birthdate;

        public User() {
        }

        public User(String firstName, String lastName, short age, String nickName, LocalDate birthdate) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
            this.nickName = Optional.ofNullable(nickName);
            this.birthdate = birthdate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.age == user.age && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.nickName, user.nickName) && Objects.equals(this.birthdate, user.birthdate);
        }

        public int hashCode() {
            return Objects.hash(this.firstName, this.lastName, this.age, this.nickName, this.birthdate);
        }
    }
}

